#include "CS_SantaFishBubbleBeam.h"
#include "CS_SantaFish.h"
const int CS_SantaFishSTATENAME_BUBBLERBEAM = ++entityStateID;
CS_SantaFishBubbleBeam::CS_SantaFishBubbleBeam()
{
	stateID = CS_SantaFishSTATENAME_BUBBLERBEAM;
	cd_counter = 0;
	cd_counter_max = 1;
	iconIndex = 0;
}

const wchar_t* CS_SantaFishBubbleBeam::GetSaveName()
{
	return L"BubblerBeam";
}

void CS_SantaFishBubbleBeam::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_SantaFish>(we);
	bool a1 = !lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;

	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	//ȼ
	if (mychar->mp >= 30)
		level = 2;
	else if (mychar->mp >= 10)
		level = 1;
	else
		level = 0;
}

void CS_SantaFishBubbleBeam::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID() && amList.size() < 2 && bubbleCharge.expired())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_SantaFish>(we);
		enable = false;
		//
		auto am = std::make_shared<CS_AmBubbleBeamCharge>(we, keyMask, level, AddToAmList, RemoveFromAmList);
		we->gameFunc->SetEntity(we, am);
		bubbleCharge = am;
		mychar->gameFunc->PlaySound(L"CS_bubblebeam_charge");
	}
	else
		enable = false;
}

void CS_SantaFishBubbleBeam::AddToAmList(std::weak_ptr<Entity> parent, std::weak_ptr<CS_AmBubbleBeam> am)
{
	auto wparent = parent.lock();
	if (wparent)
	{
		auto mychar = std::dynamic_pointer_cast<CS_SantaFish>(wparent);
		if (mychar)
		{
			auto& amList = mychar->skillBubbleBeam.amList;
			amList.push_back(am);
		}
	}
}

void CS_SantaFishBubbleBeam::RemoveFromAmList(std::weak_ptr<Entity> parent, std::weak_ptr<CS_AmBubbleBeam> am)
{
	auto wparent = parent.lock();
	if (wparent)
	{
		auto mychar = std::dynamic_pointer_cast<CS_SantaFish>(wparent);
		if (mychar)
		{
			auto& amList = mychar->skillBubbleBeam.amList;
			for (auto iter = amList.begin(); iter != amList.end(); iter++)
			{
				if ((*iter).lock() == am.lock())
				{
					amList.erase(iter);
					break;
				}
			}
		}
	}
}
