#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_SantaFishWater.h"
#include "CS_SantaFishControl.h"
#include "CS_SantaFishResist.h"
#include "CS_SantaFishJump.h"
#include "CS_SantaFishStand.h"
#include "CS_SantaFishSwim.h"
#include "CS_SantaFishFaceToBack.h"
#include "CS_SantaFishHurt.h"
#include "CS_SantaFishBubbleBeam.h"
#define CS_SANTAFISH_CREATENAME L"CS_mychar_santafish"
//ҽɫ ɣ̬
class CS_SantaFish :
    public MyCharEntity
{
public:
    CS_SantaFish();
	void Init(std::weak_ptr<Entity> self) override;
	void Step() override;
	void SetState(int stateID, int lr) override;
	void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
	void Gain(std::weak_ptr<Entity> item) override;
	void Destroy() override;
	void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
	void CrushDeath();
	void CopyFrom(std::shared_ptr<Entity>& another) override;//ԼһԼͬʵһģһ
	//ͼʾ
	float animation_moveSpeed = 0x200 / ts;
	bool animation_delay = false;//·ӳһ֡뵽
	float floatSrcX = 0;//λ
	float floatSrcY = 0;
	bool bSetTarget = false;
	std::weak_ptr<Entity> animation_target;
	//״̬ģ
	EntityStateFlashEffect stateFlash;
	EntityStateInvincible stateInvincible;
	CS_QuoteGravity stateGravity;
	CS_SantaFishWater stateWater;
	CS_SantaFishControl stateControl;
	CS_SantaFishResist stateResist;
	CS_SantaFishJump stateJump;
	CS_SantaFishStand stateStand;
	CS_SantaFishSwim stateSwim;
	CS_SantaFishFaceToBack stateFaceToBack;
	CS_SantaFishHurt stateHurt;
	//ģ
	CS_SantaFishBubbleBeam skillBubbleBeam;
	//
	std::wstring crushEvent;
};

std::shared_ptr<Entity> CreateCS_SantaFish();