#include "CS_SantaAni.h"
#include <PeSmog.h>

CS_SantaAni::CS_SantaAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_SantaAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_SantaAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ㶯
	AnimateStep();
	if (fishState)
	{
		switch (stateID)
		{
		default:
		case 0:
			//գ
			if (Random(0, 120) == 10)
			{
				wink_counter = 8;
			}
			if (wink_counter > 0)
			{
				wink_counter--;
				ani.image_index = 1;
			}
			else
			{
				ani.image_index = 0;
			}
			stateGravity.State();
			stateSplash.State();
			break;
		case 6:
			if (lr == 0)
				vx = -animation_moveSpeed;
			else
				vx = animation_moveSpeed;
			//
			stateGravity.State();
			stateSplash.State();
			break;
		case 7://¸ ״̬µ
			vx = 0;
			if (floatSrcY < y)
				vy -= 8 / ts;
			if (floatSrcY > y)
				vy += 8 / ts;
			if (vy > 0x100)
				vy = 0x100;
			if (vy < -0x100)
				vy = -0x100;
			break;
		case 8://ˮƽֱӾ
			break;
		case 9://Ŀ
			{
				auto wtarget = animation_target.lock();
				if (wtarget)
				{
					float dx = wtarget->x - x;
					float dy = wtarget->y - y;
					if (dx * dx + dy * dy > 12 * 12)
					{
						float vec_x = wtarget->x - x;
						float vec_y = wtarget->y - y;
						auto vec = XMVector2Normalize(XMVectorSet(vec_x, vec_y, 0, 0));
						float dir_vx = XMVectorGetX(vec);
						float dir_vy = XMVectorGetY(vec);
						vx = dir_vx * animation_moveSpeed;
						vy = dir_vy * animation_moveSpeed;
						lr = x > wtarget->x ? 0 : 1;
					}
					else
					{
						vx = vy = 0;
					}
					ani.sprite_index = lr == 0 ? L"mc_santafish_swim_l" : L"mc_santafish_swim_r";
				}
			}
			break;
		case 10://Ƹ ״̬µ
			if (floatSrcY < y)
				vy -= 8 / ts;
			if (floatSrcY > y)
				vy += 8 / ts;
			if (vy > 0x100)
				vy = 0x100;
			if (vy < -0x100)
				vy = -0x100;

			if (floatSrcX < x)
				vx -= 8 / ts;
			if (floatSrcX > x)
				vx += 8 / ts;
			if (vx > 0x100)
				vx = 0x100;
			if (vx < -0x100)
				vx = -0x100;
			break;
		case 11:
			if (vy < 0)
				stateGravity.SetGravityScale(0.4f);
			else
				stateGravity.SetGravityScale(1);
			if (cbRect.cbBottom && bSetLanding)
			{
				bSetLanding = false;
				vx = 0; vy = 0;
				ani.image_counter_speed = 1;
				SetPeSmog(shared_from_this(), x, y, 1, 1, 135);
				SetPeSmog(shared_from_this(), x, y, 1, 1, 45);
				SetState(201, lr);
				SetState(0, lr);
			}
			stateGravity.Step();
			break;
		}
	}
	else
	{
		stateGravity.Step();
		switch (stateID)
		{
		case 0://վ
			//գ
			if (Random(0, 120) == 10)
			{
				wink_counter = 8;
			}
			if (wink_counter > 0)
			{
				wink_counter--;
				ani.image_index = 1;
			}
			else
			{
				ani.image_index = 0;
			}
			break;
		case 3://
			vx = 0;
			vy = 0;
			//գ
			if (Random(0, 120) == 10)
			{
				wink_counter = 8;
			}
			if (wink_counter > 0)
			{
				wink_counter--;
				ani.image_index = 1;
			}
			else
			{
				ani.image_index = 0;
			}
			break;
		case 4://
			break;
		case 12://׸ףĿ
			{
				auto wanimation_target = animation_target.lock();
				if (wanimation_target)
				{
					if (wanimation_target->y < y - 8)
						ani.sprite_index = lr == 0 ? L"mc_santa_stand_lu" : L"mc_santa_stand_ru";
					else
						ani.sprite_index = lr == 0 ? L"mc_santa_stand_l" : L"mc_santa_stand_r";
				}
			}
			break;
		case 13://ӫ
			break;
		}
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_SantaAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			if (fishState)
				ani.sprite_index = lr == 0 ? L"mc_santafish_stand_l" : L"mc_santafish_stand_r";
			else
				ani.sprite_index = lr == 0 ? L"mc_santa_stand_l" : L"mc_santa_stand_r";
			if (ud == -1)
				ani.sprite_index.append(L"u");
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				if (fishState)
					ani.sprite_index = lr == 0 ? L"mc_santafish_swim_l" : L"mc_santafish_swim_r";
				else
					ani.sprite_index = lr == 0 ? L"mc_santa_move_l" : L"mc_santa_move_r";
			}
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_santa_back_l" : L"mc_santa_back_r";
			break;
		case 3://
			vx = 0;
			y -= 3;
			ani.sprite_index = lr == 0 ? L"mc_santa_sit_l" : L"mc_santa_sit_r";
			break;
		case 4://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_santa_lie_l" : L"mc_santa_lie_r";
			break;
		case 5://
			ani.sprite_index = lr == 0 ? L"mc_santa_back_l" : L"mc_santa_back_r";
			break;
		case 6://ˮ
			vy = -0x400 / ts;
			vx = lr == 0 ? vx = -0x200 / ts : vx = 0x200 / ts;
			gameFunc->PlaySound(L"CS_fishjump");
			break;
		case 7://¸ ״̬µ
			floatSrcX = x;
			floatSrcY = y + Random(-8, 8);
			vy = 0x100 / ts;
			ani.image_counter_speed = 1;
			ani.sprite_index = lr == 0 ? L"mc_santafish_swim_l" : L"mc_santafish_swim_r";
			break;
		case 8://ˮƽֱӾ
			animation_delay = true;
			vx = lr == 0 ? -animation_moveSpeed : animation_moveSpeed;
			vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_santafish_swim_l" : L"mc_santafish_swim_r";
			break;
		case 9://Ŀ
			break;
		case 10://Ƹ ״̬µ
			floatSrcX = x + (lr == 0 ? Random(-8, 0) : Random(0, 8));
			floatSrcY = y + Random(-8, 8);
			vy = 0x80 / ts;
			vx = lr == 0 ? -0x80 / ts : 0x80 / ts;
			ani.image_counter_speed = 2;
			ani.sprite_index = lr == 0 ? L"mc_santafish_swim_l" : L"mc_santafish_swim_r";
			break;
		case 11:
			vy = -0xc00 / ts - Random(0, 0x200) / ts;
			vx = lr == 0 ? vx = -animation_moveSpeed : vx = animation_moveSpeed;
			vx *= 1.5f;
			bSetLanding = true;
			break;
		case 12://׸ףĿ
			break;
		case 13://ӫ
			ani.sprite_index = lr == 0 ? L"mc_santa_glowstick_l" : L"mc_santa_glowstick_r";
			break;
		}
	}
	else
	{
		switch (stateID)
		{
		case 200://
			this->stateID = stateID;
			fishState = true;
			cbRect.left = cbRect.right = 5;
			cbRect.top = 4;
			cbRect.bottom = 4;
			cbRect.fullWaterBlock = true;
			ani.sprite_index = this->lr == 0 ? L"mc_santafish_stand_l" : L"mc_santafish_stand_r";
			SetPeSmog(shared_from_this(), x, y, 3);
			ani.hideLayerList.clear();
			break;
		case 201://
			fishState = false;
			cbRect.left = cbRect.right = 5;
			cbRect.top = 6;
			cbRect.bottom = 8;
			cbRect.fullWaterBlock = false;
			ani.sprite_index = lr == 0 ? L"mc_santa_stand_l" : L"mc_santa_stand_r";
			showGun = false;
			SetPeSmog(shared_from_this(), x, y, 3);
			break;
		}
	}
	//ͼ㶯
	AnimateStep();
}

void CS_SantaAni::SetState(std::wstring stateName, int lr)
{
	if (bSetTarget)
	{
		bSetTarget = false;
		auto& allRes = *gameFunc->GetLoadedEntity(gameFunc->entityRes);
		EntityLayer* eLayer = nullptr;
		for (auto& res : allRes)
		{
			if (res.first->layerType == 0)
			{
				eLayer = &res.second;
				break;
			}
		}
		if (eLayer)
		{
			bool bFound = false;
			//ȫʵѰ
			auto& allPlayer = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : allPlayer)
			{
				auto wplayer = p.second.lock();
				if (wplayer && wplayer->el.name == stateName)
				{
					animation_target = wplayer;
					bFound = true;
					break;
				}
			}
			//ڵͼʵѰ
			if (!bFound)
			{
				for (auto& e : eLayer->Ls)
				{
					if (e->el.eventName == stateName)
					{
						animation_target = e;
						break;
					}
				}
			}
		}
	}
	else
	{
		if (stateName == L"normal")
			SetState(0, lr);
		else if (stateName == L"walk")
			SetState(1, lr);
		else if (stateName == L"back")
			SetState(2, lr);
		else if (stateName == L"sit_on_chair")
			SetState(3, lr);
		else if (stateName == L"lie")
			SetState(4, lr);
		else if (stateName == L"back")
			SetState(5, lr);
		else if (stateName == L"jump_to_water")
			SetState(6, lr);
		else if (stateName == L"float")
		{
			this->lr = lr;
			if (stateID != 7)
				SetState(7, lr);
			else
				ani.sprite_index = lr == 0 ? L"mc_santafish_swim_l" : L"mc_santafish_swim_r";
		}
		else if (stateName == L"swim")
			SetState(8, lr);
		else if (stateName == L"set_target")
			bSetTarget = true;
		else if (stateName == L"swim_target")
			SetState(9, lr);
		else if (stateName == L"float_around")
		{
			this->lr = lr;
			if (stateID != 10)
				SetState(10, lr);
			else
				ani.sprite_index = lr == 0 ? L"mc_santafish_swim_l" : L"mc_santafish_swim_r";
		}
		else if (stateName == L"big_jump")
			SetState(11, lr);
		else if (stateName == L"cheer_target")
			SetState(12, lr);
		else if (stateName == L"glowstick")
			SetState(13, lr);
		else if (stateName == L"ignoreMovePlatform")
			cbRect.ignoreMovePlatform = lr != 0;
		else if (stateName == L"no_gravity")
		{
			vy = 0;
			stateGravity.SetEnable(lr != 0);
		}
		else if (stateName == L"transform_fish")
			SetState(200, lr);
		else if (stateName == L"transform_back")
			SetState(201, lr);
		else if (stateName == L"show_gun")
			showGun = true;
		else if (stateName == L"hide_gun")
			showGun = false;
		else if (stateName == L"dx")
			x += lr;
		else if (stateName == L"ud")
			ud = lr;
		else if (stateName == L"topdraw")
			topDraw = lr != 0;
		//ͼ㶯
		AnimateStep();
	}
}

void CS_SantaAni::AnimateStep()
{
	if (!fishState)
	{
		ani.hideLayerList.insert(0);
		ani.hideLayerList.insert(2);
		ani.hideLayerList.insert(3);
		ani.hideLayerList.insert(4);
		if (showGun)
		{
			ani.hideLayerList.erase(0);
			ani.hideLayerList.erase(3);
			ani.hideLayerList.erase(4);
		}
		else
		{
			ani.hideLayerList.erase(2);
		}
	}
}

std::shared_ptr<Entity> CreateCS_SantaAni()
{
	return std::make_shared<CS_SantaAni>();
}
