#include "CS_RainbowBubbleBase.h"
#include "CS_RainbowBubble.h"
CS_RainbowBubbleBase::CS_RainbowBubbleBase()
{
	ani.png = L"CS_CaveStoryMod";
	action_timecounter_max = 300;
	action_timecounter = Random(0, action_timecounter_max);
}

void CS_RainbowBubbleBase::Init(std::weak_ptr<Entity> self)
{
	y -= 9;
	Entity::Init(self);
}

void CS_RainbowBubbleBase::Step()
{
	if (action_timecounter > 0)
		action_timecounter--;
	if (action_timecounter == 0)
	{
		//ʺ
		auto we = std::make_shared<CS_RainbowBubble>();
		we->x = x;
		we->y = y;
		gameFunc->SetEntity(shared_from_this(), we);
		action_timecounter = action_timecounter_max;
	}
	else if (action_timecounter <= 30)
	{
		ani.sprite_index = L"ls_rainbow_bubble_grow2";
	}
	else if (action_timecounter <= 60)
	{
		ani.sprite_index = L"ls_rainbow_bubble_grow1";
	}
	else
	{
		ani.sprite_index = L"";
	}
}

std::shared_ptr<Entity> CreateCS_RainbowBubbleBase()
{
	return  std::make_shared<CS_RainbowBubbleBase>();
}
