#include "CS_QuoteTeleport.h"
const int CS_QUOTESTATENAME_TELEPORT = ++entityStateID;
CS_QuoteTeleport::CS_QuoteTeleport()
{
	enable = true;
	stateID = CS_QUOTESTATENAME_TELEPORT;
}

void CS_QuoteTeleport::State()
{
	auto we = e.lock();
	if (!we)
		return;
	if (cutoff < 1)
	{
		we->shader.usingShader = true;
		we->shader.vs = we->shader.ps = L"teleport";
		//ɫ
		if (we->shader.args.size() < 1)
			we->shader.args.resize(1);
		we->shader.args[0] = cutoff;
	}
	else
	{
		we->shader.usingShader = false;
	}
	if (bInOut)
	{
		if (cutoff > 0)
		{
			cutoff -= cutoffSpeed;
			if (cutoff < 0)
				cutoff = 0;
		}
	}
	else
	{
		if (cutoff < 1)
		{
			cutoff += cutoffSpeed;
			if (cutoff > 1)
				cutoff = 1;
		}
	}
}

void CS_QuoteTeleport::SetTeleportOut()
{
	cutoff = 1;
	bInOut = true;
}

void CS_QuoteTeleport::SetTeleportIn()
{
	cutoff = 0;
	bInOut = false;
}
