#include "CS_QuoteSpurLaserTail.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
CS_QuoteSpurLaserTail::CS_QuoteSpurLaserTail(std::shared_ptr<Entity> parent, int level, int ud, int lr)
{
	type = 2;
	attackParent = parent;
	this->level = level;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//÷ͳʼλ
	this->ud = ud;
	this->lr = lr;
	auto move = 0x1000 / ts;
	//ʱ
	action_timecounter_max = 30;
	action_timecounter = action_timecounter_max;
	//ö͹
	switch (level)
	{
	default:
	case 0:
		damage = 3;
		ani.sprite_index = ud == 0 ? L"am_spur1_lr" : L"am_spur1_ud";
		break;
	case 1:
		damage = 6;
		ani.sprite_index = ud == 0 ? L"am_spur2_lr" : L"am_spur2_ud";
		break;
	case 2:
		damage = 11;
		ani.sprite_index = ud == 0 ? L"am_spur3_lr" : L"am_spur3_ud";
		break;
	case 3:
		damage = 15;
		ani.sprite_index = ud == 0 ? L"am_spur4_lr" : L"am_spur4_ud";
		action_timecounter_max = 45;
		action_timecounter = action_timecounter_max;
		break;
	case 4:
		damage = 24;
		ani.sprite_index = ud == 0 ? L"am_spur5_lr" : L"am_spur5_ud";
		action_timecounter_max = 60;
		action_timecounter = action_timecounter_max;
		break;
	}
	damaged_limit = 100;
	damage_reset_counter = 2;
	//ǽײ
	SetCbRect_Collision();
}

void CS_QuoteSpurLaserTail::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ǽײ
	SetCbRect_Collision();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	auto& ani_no = ani.image_index;
	if (++count1 > 20)
		ani_no = count1 - 20;
	if (ani_no > 2)
		Destroy();
	if (damage && damaged_counter > 0)
		damage = 0;
}

void CS_QuoteSpurLaserTail::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	//˺
	*outDamage = damage;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_QuoteSpurLaserTail::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_QuoteSpurLaserTail::Feedback(std::weak_ptr<Entity> target)
{
	if (damaged_counter == damaged_limit)
		Destroy();
}

void CS_QuoteSpurLaserTail::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void CS_QuoteSpurLaserTail::SetCbRect_Entity()
{
	switch (level)
	{
	default:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 6;
		break;
	case 3:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 8;
		break;
	case 4:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 16;
		cbRect.enableSoild = false;
		cbRect.enableCbRect = false;
		break;
	}
	cbRect.breakStarBlock = false;
}

void CS_QuoteSpurLaserTail::SetCbRect_Collision()
{
	switch (level)
	{
	default:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 2;
		break;
	case 4:
		cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 16;
		break;
	}
	cbRect.breakStarBlock = true;
}
