#include "CS_QuoteHurt.h"
#include "CS_Quote.h"
const int CS_QuoteSTATENAME_HURT = ++entityStateID;
CS_QuoteHurt::CS_QuoteHurt()
{
	stateID = CS_QuoteSTATENAME_HURT;
}

void CS_QuoteHurt::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Quote>(we);
	if (mychar->fishState)
		we->ani.sprite_index = we->lr == 0 ? L"mc_quotefish_hurt_l" : L"mc_quotefish_hurt_r";
}

void CS_QuoteHurt::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		auto we = e.lock();
		if (!we)
			return;

		auto mychar = std::static_pointer_cast<CS_Quote>(we);
		enable = true;
		if (mychar->fishState)
		{
			mychar->action_timecounter = 30;
		}
		else
		{
			mychar->vy = -0x400 / ts;
			mychar->stateInvincible.SetInvincible(180);
		}
	}
	else
		enable = false;
}
