#pragma once
#include "Entity.h"
#include "EntityState.h"
#include "EntityStateFlashEffect.h"
#include "EntityStateInvincible.h"
#include "CS_QuoteGravity.h"
#include "CS_PuppyFishWater.h"
#include "CS_PuppyFishControl.h"
#include "CS_PuppyFishResist.h"
#include "CS_PuppyFishJump.h"
#include "CS_PuppyFishStand.h"
#include "CS_PuppyFishSwim.h"
#include "CS_PuppyFishFaceToBack.h"
#include "CS_PuppyFishHurt.h"
#include "CS_PuppyFishBubbleBeam.h"
#define CS_PUPPYFISH_CREATENAME L"CS_mychar_puppyfish"
//ҽɫ С̬
class CS_PuppyFish :
    public MyCharEntity
{
public:
    CS_PuppyFish();
	void Init(std::weak_ptr<Entity> self) override;
	void Step() override;
	void SetState(int stateID, int lr) override;
	void SetState(std::wstring stateName, int lr) override;
	void LoadSaveData() override;//ر
	void WriteSaveData() override;//д뱣
	bool Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage) override;
	void Gain(std::weak_ptr<Entity> item) override;
	void Destroy() override;
	void GetIcon(std::wstring& png, std::wstring& sprite_index, int& image_index, std::set<int>& hideLayerList) override;
	void CrushDeath();
	void CopyFrom(std::shared_ptr<Entity>& another) override;//ԼһԼͬʵһģһ
	void CheckResetFollowTarget();
	void ResetFollowTarget();
	//ͼʾ
	float animation_moveSpeed = 0x200 / ts;
	bool animation_delay = false;//·ӳһ֡뵽
	float floatSrcX = 0;//λ
	float floatSrcY = 0;
	bool bSetTarget = false;
	std::weak_ptr<Entity> animation_target;
	//״̬ģ
	EntityStateFlashEffect stateFlash;
	EntityStateInvincible stateInvincible;
	CS_QuoteGravity stateGravity;
	CS_PuppyFishWater stateWater;
	CS_PuppyFishControl stateControl;
	CS_PuppyFishResist stateResist;
	CS_PuppyFishJump stateJump;
	CS_PuppyFishStand stateStand;
	CS_PuppyFishSwim stateSwim;
	CS_PuppyFishFaceToBack stateFaceToBack;
	CS_PuppyFishHurt stateHurt;
	//ģ
	CS_PuppyFishBubbleBeam skillBubbleBeam;
	//
	std::wstring crushEvent;
};

std::shared_ptr<Entity> CreateCS_PuppyFish();