#include "CS_Press.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
CS_Press::CS_Press()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.left = cbRect.right = 8;
	cbRect.top = 17;
	cbRect.bottom = 8;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	hp_max = hp = 32;
	dropExp = 5;
	ani.sprite_index = L"ls_press";
	isTrap = true;
	ignoreTrap = true;
}

void CS_Press::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Press::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		if (cbRect.cbBottom)
			break;
		act_no = 10;
		ani_wait = 0;
		ani_no = 1;
		break;
	case 10:
		if (++ani_wait > 2)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 2)
			ani_no = 2;
		if (cbRect.cbBottom)
		{
			if (ani_no > 1)
			{
				for (int i = 0; i < 4; ++i)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x;
					pe->y = y;
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				gameFunc->PlaySound(L"CS_026_quake");
				if (gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 10, 0);
			}
			act_no = 1;
			ani_no = 0;
		}
		break;
	}
	vy += 0x20 / ts;
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	if (cbRect.cbBottom)
		cbRect.left = cbRect.right = 8;
	else
		cbRect.left = cbRect.right = 7;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
}

void CS_Press::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (cbRect.cbBottom)
		return;
	auto wdst = dst.lock();
	if (wdst && wdst->y > y)
	{
		/*if (wdst->isTrap)
			return;*/
		*outDamage = 127;
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x200 / ts;
		*outHeavy = 2;
	}
}

bool CS_Press::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_072_big_crash");
		//
		SetCS_PeSmokeLarge(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Press()
{
	return std::make_shared<CS_Press>();
}
