#include "CS_PeLightFade.h"

CS_PeLightFade::CS_PeLightFade()
{
	//
	type = 3;
	light.usingLight = true;
	//ͼ
	ani.png = L"light_fade";
	ani.sprite_index = L"r4x4";
}

void CS_PeLightFade::Step()
{
}

void CS_PeLightFade::SetState(int stateID, int lr)
{
	this->lr = lr;
	SetRadius(stateID);
	if (el.arg.length() > 0 && ParseInts(el.arg.c_str(), argbuff))
	{
		if (!argbuff.empty())
			SetRadius(argbuff.front());
		el.arg.clear();
	}
	hide = lr != 0;
}

void CS_PeLightFade::SetRadius(int r)
{
	switch (r)
	{
	default:
	case 1:
		ani.sprite_index = L"r1x1";
		break;
	case 4:
		ani.sprite_index = L"r4x4";
		break;
	case 5:
		ani.sprite_index = L"r5x5";
		break;
	case 6:
		ani.sprite_index = L"r6x6";
		break;
	case 7:
		ani.sprite_index = L"r7x7";
		break;
	}
}

std::shared_ptr<Entity> CreateCS_PeLightFade()
{
	return std::make_shared<CS_PeLightFade>();
}
