#include "CS_PeEnergyChargeFrom.h"

CS_PeEnergyChargeFrom::CS_PeEnergyChargeFrom(std::shared_ptr<Entity> parent, std::shared_ptr<Entity> from)
{
	type = 3;
	attackParent = parent;
	this->from = from;
	x = from->x;
	y = from->y;
	last_x = x;
	last_y = y;
	r = 2;
}

void CS_PeEnergyChargeFrom::Step()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		auto vec = XMVector2Normalize(XMVectorSet(wattackParent->x - x, wattackParent->y - y, 0, 0));
		auto vLen = 4;
		vx = vLen * XMVectorGetX(vec);
		vy = vLen * XMVectorGetY(vec);
	}
	if (wattackParent)
	{
		if (DisappearDistance(wattackParent->x, wattackParent->y))
			Destroy();
		else
		{
			vx *= 1.1f;
			vy *= 1.1f;
		}
	}
	else
		Destroy();
	r += 0.3f;
	//ͼ
	int index = 0;
	index += AddFillFadeCircle(fillList, index, r+2, 0, RGBA(0xf8, 0x4b, 0xff, 0xff));
	index += AddFillFadeCircle(fillList, index, r, 0, RGBA(0xff, 0xff, 0xff, 0xff));
	//ִ˶
	Entity::Step();
}

bool CS_PeEnergyChargeFrom::DisappearDistance(float dstX, float dstY)
{
	float dx = dstX - x;
	float dy = dstY - y;
	return dx * dx + dy * dy <= max(1.0f, vx * vx + vy * vy);
}

void SetCS_PeEnergyChargeFrom(std::shared_ptr<Entity> parent, std::shared_ptr<Entity> from)
{
	auto pe = std::make_shared<CS_PeEnergyChargeFrom>(parent, from);
	parent->gameFunc->SetEntity(parent, pe);
}
