#include "CS_LightningStrikeTarget.h"
#include "CS_LightningStrike.h"
CS_LightningStrikeTarget::CS_LightningStrikeTarget()
{
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_lightningstrike_target";
}

void CS_LightningStrikeTarget::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		act_no = 1;
		gameFunc->PlaySound(L"CS_103_curly_charge_gun");
		[[fallthrough]];
	case 1:
		if (++act_wait / 2 % 2)
			ani_no = 0;
		else
			ani_no = 1;

		if (act_wait == 20)
		{
			auto we = std::make_shared<CS_LightningStrike>();
			we->x = x;
			we->y = y;
			gameFunc->SetEntity(shared_from_this(), we);
		}

		if (act_wait > 40)
			Destroy();
		break;
	}
}

std::shared_ptr<Entity> CreateCS_LightningStrikeTarget()
{
	return std::make_shared<CS_LightningStrikeTarget>();
}

void SetCS_LightningStrikeTarget(std::shared_ptr<Entity> parent, float x, float y)
{
	auto we = std::make_shared<CS_LightningStrikeTarget>();
	we->x = x;
	we->y = y;
	parent->gameFunc->SetEntity(parent, we);
}
