#include "CS_LiftBlock.h"

CS_LiftBlock::CS_LiftBlock()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_liftblock";
	drawBeforeOtherEntity = true;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.left = cbRect.top = cbRect.right = cbRect.bottom = 8;
}

void CS_LiftBlock::Step()
{
	switch (stateID)
	{
	case 0:
		vx = vy = 0;
		break;
	case 1://
		vy = -moveSpeed;
		break;
	case 2://
		vy = moveSpeed;
		break;
	case 3://
		vx = -moveSpeed;
		break;
	case 4://
		vx = moveSpeed;
		break;
	}
	//ִ˶
	Entity::Step();
	if (move_counter > 0)
	{
		move_counter--;
		if (move_counter == 0)
			stateID = 0;
	}
}

void CS_LiftBlock::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal" || stateName == L"stop")
	{
		stateID = 0;
	}
	else if (stateName == L"up")
	{
		stateID = 1;
		move_counter = lr;
	}
	else if (stateName == L"down")
	{
		stateID = 2;
		move_counter = lr;
	}
	else if (stateName == L"left")
	{
		stateID = 3;
		move_counter = lr;
	}
	else if (stateName == L"right")
	{
		stateID = 4;
		move_counter = lr;
	}
}

std::shared_ptr<Entity> CreateCS_LiftBlock()
{
	return std::make_shared<CS_LiftBlock>();
}
