#include "CS_KingControl.h"
#include "CS_King.h"
#include "CS_PeLittleStar.h"
#include <PeSmog.h>
const int CS_KingSTATENAME_CONTROL = ++entityStateID;
CS_KingControl::CS_KingControl()
{
	enable = true;
	SetPhysice(false);
	stateID = CS_KingSTATENAME_CONTROL;
}

void CS_KingControl::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_King>(we);
	auto& faceToBack = mychar->faceToBack;
	auto& stateResist = mychar->stateResist;
	//״̬
	if (we->cbRect.cbBottom)
	{
		if (we->ud == 1 && !mychar->InAction())
			we->ud = 0;
	}
	if (!we->input.GetJump())
		we->blockJump = false;
	stateResist.apply_resistH = true;
	bClimb = false;
	//KEYֹҲ
	if (we->gameFunc->IsLockKeyboard && we->gameFunc->IsLockKeyboard(we->gameFunc->gameScript))
	{
		we->input.key = 0;
		for (auto& p : we->axis)
			p = 0;
	}
	//Ծҿƶ
	if (bClimb_freezeControl_counter > 0)
		bClimb_freezeControl_counter--;
	if (we->cbRect.cbBottom)
		bClimb_freezeControl_counter = 0;
	//	
	if (we->input.GetUp() || we->axis[0] < 0)
	{
		if (!mychar->InAction())
			we->ud = -1;
		faceToBack = false;
	}
	//
	else if (we->input.GetDown() || we->axis[1] > 0)
	{
		if (!mychar->InAction() && !we->cbRect.cbBottom)
			we->ud = 1;
	}
	//ʲô
	else
	{
		if (!mychar->InAction())
			we->ud = 0;
	}
	JumpControl();
	//
	if (we->cbRect.cbBottom && playLandingSound)
	{
		we->gameFunc->PlaySound(L"CS_023_thud");
		playLandingSound = false;
	}
	if (!we->cbRect.cbBottom)
		playLandingSound = true;
	//ײͷ
	if (!we->cbRect.cbTop)
		playBonkHeadSound = true;
	if (we->cbRect.cbTop && playBonkHeadSound)
	{
		we->gameFunc->PlaySound(L"CS_003_quote_bonkhead");
		playBonkHeadSound = false;
		SetCS_PeLittleStar(we, we->x, we->y - we->cbRect.top);
		SetCS_PeLittleStar(we, we->x, we->y - we->cbRect.top);
	}
	//ƶ
	if (!mychar->InAction())
	{
		MoveControl();
		//
		if (we->input.GetLeft())
			we->lr = 0;
		else if (we->input.GetRight())
			we->lr = 1;
		if (we->input.GetJump())
			faceToBack = false;
		//¼
		if (we->input.GetDown() && we->cbRect.cbBottom && !faceToBack_disable)
		{
			faceToBack = true;
		}
		//Ƿδƶ
		if (stateResist.apply_resistH)
			mychar->ChangeState(mychar->stateStand.GetStateID());
		else
			mychar->ChangeState(mychar->stateMove.GetStateID());
		//Ƿڿ
		if (!we->cbRect.cbBottom)
			mychar->ChangeState(mychar->stateAir.GetStateID());
		//Ƿ
		if (bClimb)
			mychar->ChangeState(mychar->stateClimb.GetStateID());
	}
	if (!bClimb)
		climbEffect_counter = climbEffect_counter_max;
	/*------------------¼------------------*/
	if (!we->input.GetDown())
		faceToBack_disable = false;
	if (!stateResist.apply_resistH)
		faceToBack = false;
	/*---------------ûаκμܼ--------------------*/
	if (!(!we->input.GetAtk() &&
		!we->input.GetSkill_1() &&
		!we->input.GetSkill_2() &&
		!we->input.GetSkill_3() &&
		!we->input.GetSkill_4() &&
		!we->input.GetSkill_5() &&
		!we->input.GetSkill_6()))
		faceToBack = false;
	//Ϸ¼Ƿеβ
	if (we->faceToBackEnd)
	{
		we->faceToBackEnd = false;//ʹ־
		faceToBack = false;//һָ¼Գ
	}
	if (!we->cbRect.cbBottom)
	{
		faceToBack = false;
	}
	//
	if (faceToBack)
	{
		mychar->ChangeState(mychar->stateFaceToBack.GetStateID());
		we->inCheckingEvent = true;
		faceToBack_disable = true;
	}
	else
	{
		we->inCheckingEvent = false;
	}
}

void CS_KingControl::SetPhysice(bool bInWater)
{
	if (bInWater)
	{
		max_move = inwater_max_move;
		move = inwater_move;
		move2 = inwater_move2;
	}
	else
	{
		max_move = ground_max_move;
		move = ground_move;
		move2 = ground_move2;
	}
}

void CS_KingControl::MoveControl()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_King>(we);
	auto& stateResist = mychar->stateResist;
	//ƶ
	//
	if (we->input.GetLeft() || we->axis[2] < 0)
	{
		stateResist.apply_resistH = false;
		//Ƿֱ
		float joyMax_move;
		if (we->axis[2] < 0)
		{
			joyMax_move = max_move * -we->axis[2];
			//ı䶯ٶ
			we->ani.image_counter_speed = -we->axis[2];
		}
		else
		{
			joyMax_move = max_move;
			we->ani.image_counter_speed = 1;
		}
		if (we->vx > -joyMax_move)
		{
			if (we->cbRect.cbLeft)
				we->vx = -joyMax_move / 2;
			else if (we->cbRect.cbBottom)
				if (we->vx - move > -joyMax_move)
					we->vx -= move;
				else
					we->vx = -joyMax_move;
			else
				if (we->vx - move2 > -joyMax_move)
					we->vx -= move2;
				else
					we->vx = -joyMax_move;
		}
		//
		if (we->cbRect.cbLeft && !we->cbRect.cbBottom)
		{
			bClimb = true;
			bClimb_freezeControl_counter = 0;
			//½ٶ
			if (we->vy > max_move / 2)
			{
				we->vy = max_move / 2;
				if (!we->cbRect.inWater)
				{
					if (climbEffect_counter > 0)
					{
						climbEffect_counter--;
						if (climbEffect_counter == 0)
						{
							climbEffect_counter = climbEffect_counter_max;
							//Ч
							SetPeSmogClimb(we, we->x, we->y, 1, 1, -90);
							we->gameFunc->PlaySound(L"Climb");
						}
					}
				}
			}
		}
	}
	//
	else if (we->input.GetRight() || we->axis[3] > 0)
	{
		stateResist.apply_resistH = false;
		//Ƿֱ
		float joyMax_move;
		if (we->axis[3] > 0)
		{
			joyMax_move = max_move * we->axis[3];
			//ı䶯ٶ
			we->ani.image_counter_speed = we->axis[3];
		}
		else
		{
			joyMax_move = max_move;
			we->ani.image_counter_speed = 1;
		}
		if (we->vx < joyMax_move)
		{
			if (we->cbRect.cbRight)
				we->vx = joyMax_move / 2;
			else if (we->cbRect.cbBottom)
			{
				if (we->vx + move < joyMax_move)
					we->vx += move;
				else
					we->vx = joyMax_move;
			}
			else
			{
				if (we->vx + move2 < joyMax_move)
					we->vx += move2;
				else
					we->vx = joyMax_move;
			}
		}
		//
		if (we->cbRect.cbRight && !we->cbRect.cbBottom)
		{
			bClimb = true;
			bClimb_freezeControl_counter = 0;
			//½ٶ
			if (we->vy > max_move / 2)
			{
				we->vy = max_move / 2;
				if (!we->cbRect.inWater)
				{
					if (climbEffect_counter > 0)
					{
						climbEffect_counter--;
						if (climbEffect_counter == 0)
						{
							climbEffect_counter = climbEffect_counter_max;
							//Ч
							SetPeSmogClimb(we, we->x, we->y, 1, 1, -90);
							we->gameFunc->PlaySound(L"Climb");
						}
					}
				}
			}
		}
	}
}

void CS_KingControl::JumpControl()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_King>(we);
	auto& stateGravity = mychar->stateGravity;
	//Ծ
	if (we->input.GetJump() &&
		we->vy < 0)
		stateGravity.gravity = stateGravity.gravity_default * 0.4f;
	else
		stateGravity.gravity = stateGravity.gravity_default;
}
