#include "CS_JackFishControl.h"
#include "CS_JackFish.h"
#include "CS_PeLittleStar.h"
const int CS_JackFishSTATENAME_CONTROL = ++entityStateID;
CS_JackFishControl::CS_JackFishControl()
{
	enable = true;
	SetPhysice(true);
	stateID = CS_JackFishSTATENAME_CONTROL;
}

void CS_JackFishControl::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_JackFish>(we);
	auto& faceToBack = mychar->faceToBack;
	auto& stateResist = mychar->stateResist;
	if (!we->input.GetJump())
		we->blockJump = false;
	stateResist.apply_resistH = true;
	//KEYֹҲ
	if (we->gameFunc->IsLockKeyboard && we->gameFunc->IsLockKeyboard(we->gameFunc->gameScript))
	{
		we->input.key = 0;
		for (auto& p : we->axis)
			p = 0;
	}
	//	
	if (we->input.GetUp() || we->axis[0] < 0)
	{
		if (!mychar->InAction())
			we->ud = -1;
		faceToBack = false;
	}
	//
	else if (we->input.GetDown() || we->axis[1] > 0)
	{
		if (!mychar->InAction() && !we->cbRect.cbBottom)
			we->ud = 1;
	}
	//ʲô
	else
	{
		if (!mychar->InAction())
			we->ud = 0;
	}
	JumpControl();
	//ײͷ
	if (!we->cbRect.cbTop)
		playBonkHeadSound = true;
	if (we->cbRect.cbTop && playBonkHeadSound)
	{
		we->gameFunc->PlaySound(L"CS_003_quote_bonkhead");
		playBonkHeadSound = false;
		SetCS_PeLittleStar(we, we->x, we->y - we->cbRect.top);
		SetCS_PeLittleStar(we, we->x, we->y - we->cbRect.top);
	}
	//ƶ
	if (!mychar->InAction())
	{
		MoveControl();
		//
		if (we->input.GetLeft())
			we->lr = 0;
		else if (we->input.GetRight())
			we->lr = 1;
		if (we->input.GetJump())
			faceToBack = false;
		//¼
		if (we->input.GetDown() && we->cbRect.cbBottom && !faceToBack_disable)
		{
			faceToBack = true;
		}
		//Ƿδƶ
		if (stateResist.apply_resistH)
			mychar->ChangeState(mychar->stateStand.GetStateID());
		else
			mychar->ChangeState(mychar->stateSwim.GetStateID());
		//Ƿڿ
		if (!we->cbRect.cbBottom)
			mychar->ChangeState(mychar->stateSwim.GetStateID());
	}
	/*------------------¼------------------*/
	if (!we->input.GetDown())
		faceToBack_disable = false;
	if (!stateResist.apply_resistH)
		faceToBack = false;
	/*---------------ûаκμܼ--------------------*/
	if (!(!we->input.GetAtk() &&
		!we->input.GetSkill_1() &&
		!we->input.GetSkill_2() &&
		!we->input.GetSkill_3() &&
		!we->input.GetSkill_4() &&
		!we->input.GetSkill_5() &&
		!we->input.GetSkill_6()))
		faceToBack = false;
	//Ϸ¼Ƿеβ
	if (we->faceToBackEnd)
	{
		we->faceToBackEnd = false;//ʹ־
		faceToBack = false;//һָ¼Գ
	}
	if (!we->cbRect.cbBottom)
	{
		faceToBack = false;
	}
	//
	if (faceToBack)
	{
		mychar->ChangeState(mychar->stateFaceToBack.GetStateID());
		we->inCheckingEvent = true;
		faceToBack_disable = true;
	}
	else
	{
		we->inCheckingEvent = false;
	}
}

void CS_JackFishControl::SetPhysice(bool bInWater)
{
	if (bInWater)
	{
		max_move = inwater_max_move;
		move = inwater_move;
	}
	else
	{
		max_move = ground_max_move;
		move = ground_move;
	}
}

void CS_JackFishControl::MoveControl()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_JackFish>(we);
	auto& stateResist = mychar->stateResist;
	bool bSetAniSpeed = false;
	//ƶ
	//
	if (we->input.GetLeft() || we->axis[2] < 0)
	{
		stateResist.apply_resistH = false;
		//Ƿֱ
		float joyMax_move;
		if (we->axis[2] < 0)
		{
			joyMax_move = max_move * -we->axis[2];
		}
		else
		{
			joyMax_move = max_move;
		}
		if (we->vx > -joyMax_move)
		{
			if (we->cbRect.cbLeft)
				we->vx = -joyMax_move / 2;
			if (we->vx - move > -joyMax_move)
				we->vx -= move;
			else
				we->vx = -joyMax_move;
			//ı䶯ٶ
			we->ani.image_counter_speed = abs(we->vx) / abs(max_move);
			bSetAniSpeed = true;
		}
	}
	//
	else if (we->input.GetRight() || we->axis[3] > 0)
	{
		stateResist.apply_resistH = false;
		//Ƿֱ
		float joyMax_move;
		if (we->axis[3] > 0)
		{
			joyMax_move = max_move * we->axis[3];
		}
		else
		{
			joyMax_move = max_move;
		}
		if (we->vx < joyMax_move)
		{
			if (we->cbRect.cbRight)
				we->vx = joyMax_move / 2;
			if (we->vx + move < joyMax_move)
				we->vx += move;
			else
				we->vx = joyMax_move;
			//ı䶯ٶ
			we->ani.image_counter_speed = abs(we->vx) / abs(max_move);
			bSetAniSpeed = true;
		}
	}
	if (!bSetAniSpeed)
	{
		if (mychar->stateSwim.GetEnable())
			we->ani.image_index = 0;

		we->ani.image_counter_speed = 0;
	}
}

void CS_JackFishControl::JumpControl()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_JackFish>(we);
	auto& stateGravity = mychar->stateGravity;
	//Ծ
	if (we->input.GetJump() &&
		we->vy < 0)
		stateGravity.gravity = stateGravity.gravity_default * 0.4f;
	else
		stateGravity.gravity = stateGravity.gravity_default;
}
