#include "CS_JackCatcherBubble.h"

CS_JackCatcherBubble::CS_JackCatcherBubble(std::weak_ptr<Entity> target, bool bCaught)
{
	this->target = target;
	this->bCaught = bCaught;
	auto wtarget = target.lock();
	if (wtarget)
	{
		x = wtarget->x;
		y = wtarget->y;
		target_vx = vx = wtarget->vx;
		target_vy = vy = wtarget->vy;
		//沢رղ׽Ĺ״̬
		target_attackState = wtarget->attackState;
		target_damage_reset_counter = wtarget->damage_reset_counter;
		target_attackState_reset_counter_max = wtarget->attackState_reset_counter_max;
		target_drawBeforeOtherEntity = wtarget->drawBeforeOtherEntity;
		//ײ
		cbRect.left = max(wtarget->cbRect.left, 4);
		cbRect.right = max(wtarget->cbRect.right, 4);
		cbRect.top = max(wtarget->cbRect.top, 4);
		cbRect.bottom = max(wtarget->cbRect.bottom, 8);
		wtarget->gameFunc->PlaySound(L"CS_021_bubble");
		cbRect.enableSelfSoild = wtarget->cbRect.enableSelfSoild;
		cbRect.enableMovePlatform = wtarget->cbRect.enableMovePlatform;
	}
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	ani.sprite_index = L"am_catcher_bubble_air";
	el.name = L"resetlevel_delete";
}

void CS_JackCatcherBubble::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_JackCatcherBubble::Step()
{
	auto wtarget = target.lock();
	if (!wtarget)
	{
		Destroy();
		return;
	}
	wtarget->attackState = false;
	wtarget->attackState_reset_counter_max = -1;
	wtarget->damage_reset_counter = -1;
	wtarget->drawBeforeOtherEntity = true;
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
	}
	vx /= 1.05f;
	stateGravity.Step();
	if (cbRect.cbBottom)
		ani.sprite_index = L"am_catcher_bubble_pack";
	else if (vy > 0x300 / ts)
		ani.sprite_index = L"am_catcher_bubble_fall";
	//ʱ
	if (controlTime > 0)
	{
		controlTime--;
		if (controlTime == 0)
		{
			SetSpray();
			Destroy();
			return;
		}
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//Ŀ
	TargetControl();
}

void CS_JackCatcherBubble::TargetControl()
{
	auto wtarget = target.lock();
	if (!wtarget)
		return;
	if (wtarget->inUsing == false)
	{
		target.reset();
		SetSpray();
		Destroy();		
		return;
	}
	//Ŀٶ
	wtarget->vx = 0;
	wtarget->vy = 0;
	wtarget->ClearCollisionResult();
	wtarget->x = x;
	wtarget->last_x = last_x;
	wtarget->y = y;
	wtarget->last_y = last_y;
}

void CS_JackCatcherBubble::SetSpray()
{
	int num = Random(2, 6);
	for (int i = 0; i < num; i++)
	{
		auto pe = gameFunc->GameCreateEntity(L"pe_spray");
		pe->x = x + Random(-8, 8);
		pe->y = y - 8 + Random(-8, 8);
		gameFunc->SetEntity(shared_from_this(), pe);
	}
}

void CS_JackCatcherBubble::Destroy()
{
	auto wtarget = target.lock();
	if (wtarget)
	{
		//ָ״̬
		wtarget->attackState = target_attackState;
		wtarget->damage_reset_counter = target_damage_reset_counter;
		wtarget->attackState_reset_counter_max = target_attackState_reset_counter_max;
		wtarget->drawBeforeOtherEntity = target_drawBeforeOtherEntity;
		wtarget->vx = target_vx;
		wtarget->vy = target_vy;
		//貶ʱ
		wtarget->ignoreCaught_counter = 180;
		if (bCaught)
			wtarget->EndCaught(shared_from_this());
	}
	Entity::Destroy();
}
