#include "CS_JackCatcherBomb.h"
#include "CS_PeGunShotSpark.h"
#include "CS_JackCatcherBombBlaster.h"
CS_JackCatcherBomb::CS_JackCatcherBomb(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	moveSpeed = 0x600 / ts;
	existTime = 100;
	ani.sprite_index = lr == 0 ? L"am_catcher_bomb_l" : L"am_catcher_bomb_r";
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 4;
		else
			x = parent->x + 4;
		y = parent->y - 12;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
		vx = 0;
		vy = -moveSpeed;
	}
	else if (ud == 0)
	{
		y = parent->y;
		if (lr == 0)
		{
			x = parent->x - 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x - 7;//
			vx = -moveSpeed;
		}
		else
		{
			x = parent->x + 12;
			SetCS_PeGunShotSpark(parent, x, y);
			x = parent->x + 7;//
			vx = moveSpeed;
		}
		vy = 0;
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 10;
		SetCS_PeGunShotSpark(parent, x, y);
		x = parent->x;//
		vx = 0;
		vy = moveSpeed;
	}
	auto wcore = std::make_shared<CS_JackCatcherBombCore>();
	core = wcore;
	parent->gameFunc->SetEntity(parent, wcore);
	//Ч
	parent->gameFunc->PlaySound(L"CS_048_bubbler");
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	SetCbRect_Collision();
	hp_max = hp = 1;
}

void CS_JackCatcherBomb::Step()
{
	//ͼ
	if (ani.png.length() == 0)
	{
		ani.png = L"CS_CaveStoryMod";
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ǽײ
	SetCbRect_Collision();
	//ִײ
	Collision();
	//ʵײ
	SetCbRect_Entity();
	//ǽը
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		Boom();
	}
	//ͼʧ
	if (IsOutOfMap(128))
		Destroy();
	//ʱ
	if (existTime > 0)
	{
		existTime--;
		if (existTime == 0)
			Boom();
	}
	//
	auto wcore = core.lock();
	if (wcore)
	{
		wcore->x = x;
		wcore->last_x = last_x;
		wcore->y = y;
		wcore->last_y = last_y;
	}
}

void CS_JackCatcherBomb::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wdst = dst.lock();
	if (!wdst)
		return;
	if (wdst->ignoreCaught)
		return;
	if (wdst->ignoreCaught_counter > 0)
		return;
	//
	auto wsrcTarget = wdst;
	auto wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
	if (wcaughtTarget)
	{
		while (wcaughtTarget != wsrcTarget)
		{
			wsrcTarget = wcaughtTarget;
			wcaughtTarget = wsrcTarget->BeginCaught(shared_from_this()).lock();
			if (!wcaughtTarget)
			{
				wcaughtTarget = wsrcTarget;
				break;
			}
		}
	}
	else
	{
		//Ჶһ
		if (wsrcTarget->type == 0)
			return;
		wcaughtTarget = wsrcTarget;
	}
	if (wcaughtTarget)
	{
		Boom();
	}
}

bool CS_JackCatcherBomb::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	auto wsrc = src.lock();
	if (!wsrc)
		return false;
	if (wsrc->ignoreCaught)
		return false;
	if (wsrc->ignoreCaught_counter > 0)
		return false;

	int srcType = wsrc->type;
	auto wsrc_attackParent = wsrc->attackParent.lock();
	if (wsrc_attackParent)
		srcType = wsrc_attackParent->type;
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		//зӪ
		if (srcType == wattackParent->type)
			return false;
	}
	//Ŀ
	Boom();
	return false;
}

void CS_JackCatcherBomb::SetCbRect_Entity()
{
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 8;
}

void CS_JackCatcherBomb::SetCbRect_Collision()
{
	cbRect.left = 3;
	cbRect.right = 3;
	cbRect.top = 3;
	cbRect.bottom = 3;
}

void CS_JackCatcherBomb::Boom()
{
	gameFunc->PlaySound(L"catcher_bomb");
	int r = 4;//ը뾶
	int delayTime = 2;

	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		//ñը
		SetCS_JackCatcherBombBlaster(wattackParent, 5, x, y);
		//ð뾶ϵ
		for (int i = 0; i < r; i++)
		{
			//
			if (i + 1 == r)
				SetCS_JackCatcherBombBlaster(wattackParent, 8, x, y - (i + 1) * 16, i * delayTime);
			else
				SetCS_JackCatcherBombBlaster(wattackParent, 1, x, y - (i + 1) * 16, i * delayTime);
			//
			if (i + 1 == r)
				SetCS_JackCatcherBombBlaster(wattackParent, 2, x, y + (i + 1) * 16, i * delayTime);
			else
				SetCS_JackCatcherBombBlaster(wattackParent, 1, x, y + (i + 1) * 16, i * delayTime);
			//
			if (i + 1 == r)
				SetCS_JackCatcherBombBlaster(wattackParent, 4, x - (i + 1) * 16, y, i * delayTime);
			else
				SetCS_JackCatcherBombBlaster(wattackParent, 0, x - (i + 1) * 16, y, i * delayTime);
			//
			if (i + 1 == r)
				SetCS_JackCatcherBombBlaster(wattackParent, 6, x + (i + 1) * 16, y, i * delayTime);
			else
				SetCS_JackCatcherBombBlaster(wattackParent, 0, x + (i + 1) * 16, y, i * delayTime);
		}
	}
	Destroy();
}

void CS_JackCatcherBomb::Destroy()
{
	auto wcore = core.lock();
	if (wcore)
	{
		wcore->x = x;
		wcore->y = y;
		wcore->Destroy();
	}
	Entity::Destroy();
}
