#include "CS_JackCatcher.h"
#include "CS_Jack.h"
#include "CS_JackCatcherBlade.h"
#include "CS_JackCatcherBomb.h"
const int CS_JackSTATENAME_CATCHER = ++entityStateID;
CS_JackCatcher::CS_JackCatcher()
{
	stateID = CS_JackSTATENAME_CATCHER;
	cd_counter = 0;
	cd_counter_max = 60;
	iconIndex = 1;
}

const wchar_t* CS_JackCatcher::GetSaveName()
{
	return L"Catcher";
}

const wchar_t* CS_JackCatcher::GetFuncName()
{
	return L"JackSkill_Catcher";
}

const wchar_t* CS_JackCatcher::GetCheckFuncName()
{
	return L"JackSkill_Catcher_Check";
}

void CS_JackCatcher::SubStep()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Jack>(we);
	bool a1 = !lock;
	bool b1 = (mychar->input.key & keyMask);
	bool c1 = cd_counter == 0 && mychar->mp >= mp_cost;

	bool a = a1;
	bool b = b1;
	bool c = c1;
	//
	if (a && b && c)
	{
		mychar->lastSkill = this;
		mychar->ChangeState(GetStateID());
	}
	//ȴʱ
	if (cd_counter > 0)
		cd_counter--;
	//ȼ
	if (mychar->mp >= 30)
		level = 2;
	else if (mychar->mp >= 10)
		level = 1;
	else
		level = 0;
	EntitySkillState::SubStep();
}

void CS_JackCatcher::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		//ʼ
		auto we = e.lock();
		if (!we)
			return;
		auto mychar = std::static_pointer_cast<CS_Jack>(we);
		enable = false;
		//
		cd_counter = cd_counter_max;
		//ȼ
		if (mychar->mp >= 30)
			level = 2;
		else if (mychar->mp >= 10)
			level = 1;
		else
			level = 0;
		//
		if (level == 2)
		{
			auto am = std::make_shared<CS_JackCatcherBomb>(mychar);
			we->gameFunc->SetEntity(we, am);
		}
		else
		{
			auto am = std::make_shared<CS_JackCatcherBlade>(mychar, level);
			we->gameFunc->SetEntity(we, am);
		}
		//סüܼ
		mychar->inputLock.key |= keyMask;
	}
	else
		enable = false;
}
