#include "CS_JackBubbleSpineBlade.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"

CS_JackBubbleSpineBlade::CS_JackBubbleSpineBlade(std::shared_ptr<Entity> parent, float x, float y)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.breakStarBlock = true;
	//ײ
	cbRect.left = 2;
	cbRect.right = 2;
	cbRect.top = 2;
	cbRect.bottom = 2;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	parent->gameFunc->PlaySound(L"CS_100_bubbler3");
	SetCS_PeGunShotSpark(parent, x, y);
	this->x = x;
	this->y = y;
	action_timecounter_max = 32;
	if (ud == 0)
		ani.sprite_index = L"am_bubbler_spine_lr";
	else
		ani.sprite_index = L"am_bubbler_spine_ud";
	if (ud == -1)
	{
		vy = (-Random(10, 16) * 0x200) / 2 / ts;
	}
	else if (ud == 0)
	{
		if (lr == 0)
			vx = (-Random(10, 16) * 0x200) / 2 / ts;
		else
			vx = (Random(10, 16) * 0x200) / 2 / ts;
	}
	else
	{
		vy = (Random(10, 16) * 0x200) / 2 / ts;
	}
	action_timecounter = action_timecounter_max;
}

void CS_JackBubbleSpineBlade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_028_shot_hit");
		SetCS_PeGunShotHit(shared_from_this(), x, y);
		Destroy();
	}
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
}

void CS_JackBubbleSpineBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_JackBubbleSpineBlade::Feedback(std::weak_ptr<Entity> target)
{
	Destroy();
}

void CS_JackBubbleSpineBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget->hp > 0)
			SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
	}
}

void CS_JackBubbleSpineBlade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}
