#include "CS_Fan_Left.h"
#include "CS_PeWaterParticles.h"

CS_Fan_Left::CS_Fan_Left()
{
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_fan_left";
	drawBeforeOtherEntity = true;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
}

void CS_Fan_Left::Step()
{
	auto& ani_no = ani.image_index;
	switch (act_no)
	{
	case 0:
		if (lr == 1)
			act_no = 2;
		else
			ani_no = 1;
		[[fallthrough]];
	case 1:
		ani_no = 0;
		break;

	case 2:
		if (++ani_wait > 0)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 2)
			ani_no = 0;
		if (gameFunc->GetGlobalEntityTable)
		{
			auto& table = *gameFunc->GetGlobalEntityTable(gameFunc->game);
			for (auto& p : table)
			{
				auto wplayer = p.second.lock();
				if (wplayer)
				{
					if (wplayer->el.name == L"null")
						continue;
					if (wplayer->y < y + 0x1000 / ts && wplayer->y > y - 0x1000 / ts && wplayer->x < x && wplayer->x > x - 0xC000 / ts)
					{
						wplayer->vx -= 0x88 / ts;
						if ((wplayer->cbRect.pxaBottom >= 0x2 && wplayer->cbRect.pxaBottom <= 0xe) ||
							(wplayer->cbRect.pxaBottom >= 0x12 && wplayer->cbRect.pxaBottom <= 0x1e))
							wplayer->cbRect.pxaBottom += 0x20;
					}
				}
			}
		}
		if (Random(0, 5) == 1)
			SetCS_PeWaterParticles(shared_from_this(), x, y + Random(-8, 8), 0);
		break;
	}
}

void CS_Fan_Left::SetState(int stateID, int lr)
{
	this->lr = lr;
}

std::shared_ptr<Entity> CreateCS_Fan_Left()
{
	return std::make_shared<CS_Fan_Left>();
}
