#include "CS_FallingSpike.h"
#include "CS_PeSmoke.h"
CS_FallingSpike::CS_FallingSpike()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.left = cbRect.right = 8;
	cbRect.bottom = 17;
	cbRect.top = 8;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.enableSelfSoild = true;
	cbRect.enableMovePlatform = true;
	cbRect.breakStarBlock = true;
	ani.sprite_index = L"ls_fallingspike";
	ani.image_index = 0;
	isTrap = true;
}

void CS_FallingSpike::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	srcY = y;
	Entity::Init(self);
}

void CS_FallingSpike::Step()
{
	if (y != srcY)
		fix = false;
	if (!fix)
	{
		stateGravity.Step();
		stateSplash.Step();
		if (!cbRect.cbBottom)
			bLanding = false;
		if (!bLanding)
		{
			if (cbRect.cbBottom)
			{
				gameFunc->PlaySound(L"CS_012_block_destroy");
				SetCS_PeSmokeSmall(shared_from_this(), x, y);
				bLanding = true;
			}
		}
	}
	if (!fix)
	{
		//һײ
		Entity::ClearCollisionResult();
	}
	//ִ˶
	Entity::Step();
	if (!fix)
	{
		//ִײ
		Entity::Collision();
	}
}

void CS_FallingSpike::SetState(int stateID, int lr)
{
	ani.sprite_index = el.arg;
}

void CS_FallingSpike::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (cbRect.cbBottom && dst.lock() != cbRect.movingPlatformBottom.lock())
		return;
	auto wdst = dst.lock();
	if (wdst && wdst->y > y + 15)
	{
		*outDamage = 127;
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x200 / ts;
		*outHeavy = 2;
	}
}

std::weak_ptr<Entity> CS_FallingSpike::BeginCaught(std::weak_ptr<Entity> e)
{
	return shared_from_this();
}

void CS_FallingSpike::EndCaught(std::weak_ptr<Entity> e)
{
}

bool CS_FallingSpike::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = 0;
	return true;
}

std::shared_ptr<Entity> CreateCS_FallingSpike()
{
	return std::make_shared<CS_FallingSpike>();
}
