#include "CS_Enemy_GolemRock.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "PeSmog.h"

CS_Enemy_GolemRock::CS_Enemy_GolemRock()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"ls_golem_rock";
	ani.image_index = 2;
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 32;
	cbRect.bottom = 8;
	hp_max = hp = 120;
	dropExp = 19;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	drawBeforeOtherEntity = true;
	speedDir = true;
}

void CS_Enemy_GolemRock::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	stateGravity.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GolemRock::Step()
{
	stateSplash.Step();
	if (wake_counter > 0)
	{
		wake_counter--;
	}
	switch (stateID)
	{
	case 0:
		type = 0;//αװ
		break;
	case 1://(жӳ٣
		SetCS_PeSmokeWater(shared_from_this(), x, y, 3);
		wake_counter = 120;
		stateID = 2;
		bAction = true;
		ani.image_index = 0;
		type = 2;//ԭ
		[[fallthrough]];
	case 2://жӳ
		if (wake_counter > 0)
			wake_counter--;
		if (wake_counter == 0)
			stateID = 3;
		break;
	case 3://ж
		//ʱ
		if(bNormalMode)
			up_counter = 60;
		else
			up_counter = 30;
		stateID = 4;
		break;
	case 4://
		if (bNormalMode)
			vy = -0x400 / ts;
		else
			vy = -0x800 / ts;
		if (up_counter > 0)
		{
			up_counter--;
		}
		else
		{
			//ʱ
			trace_counter = Random(20, 120);
			stateID = 5;
			//ѡһҽ
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
					target = wplayer;
			}
		}
		break;
	case 5://
		vy = 0;
		if (trace_counter > 0)
		{
			trace_counter--;
			//ڿƶ
			auto wplayer = target.lock();
			if (wplayer)
			{
				//㹻ֱѹ
				if (abs(x - wplayer->x) <= 4)
				{
					stateID = 6;
				}
				if (bNormalMode)
					vx = x < wplayer->x ? 0x400 / ts : -0x400 / ts;
				else
					vx = x < wplayer->x ? 0x800 / ts : -0x800 / ts;
			}
			else
			{
				stateID = 6;
			}
		}
		else
		{
			stateID = 6;
		}
		break;
	case 6://ѹͣʱ
		vx = 0;
		press_counter = 16;
		stateID = 7;
		break;
	case 7://ѹͣ״̬
		if (press_counter > 0)
			press_counter--;
		else
			stateID = 8;
		break;
	case 8://ѹ״̬
		if (cbRect.cbBottom)
		{
			stateID = 9;
			for (int i = 0; i < 4; i++)
			{
				auto pe = std::make_shared<CS_PeSmoke>();
				pe->x = x + Random(-12, 12);
				pe->y = y + Random(-12, 12);
				pe->vx = Random(-341, 341) / ts;
				pe->vy = Random(-0x600, 0) / ts;
				gameFunc->SetEntity(shared_from_this(), pe);
			}
			gameFunc->PlaySound(L"CS_026_quake");
			if (gameFunc->SetQuake)
				gameFunc->SetQuake(gameFunc->game, 30, 0);
		}
		else
		{
			if (bNormalMode)
				vy = 0x800 / ts;
			else
				vy = 0x1000 / ts;
		}
		break;
	case 9://óײͣʱԼĿ
		press_counter = 16;
		stateID = 10;
		//ѡһҽгײ
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				target = wplayer;
				lr = x > wplayer->x ? 0 : 1;
			}
		}
		break;
	case 10://ײͣʱ
		if (press_counter > 0)
			press_counter--;
		else
			stateID = 11;
		break;
	case 11://гײ
		if (lr == 0)
		{
			//ײ
			if (bNormalMode)
				vx = -0x600 / ts;
			else
				vx = -0xc00 / ts;
			if (cbRect.cbLeft)
				stateID = 12;
		}
		else
		{
			//ҳײ
			if (bNormalMode)
				vx = 0x600 / ts;
			else
				vx = 0xc00 / ts;
			if (cbRect.cbRight)
				stateID = 12;
		}
		walkSound += abs(vx);
		if (walkSound > 32)
		{
			walkSound -= 32;
			gameFunc->PlaySound(L"CS_107_block_move");
			SetPeSmog(shared_from_this(), x, y, 1, 1, lr == 0 ? 0 : 180.0f);
		}
		break;
	case 12://ײͣ
		gameFunc->PlaySound(L"CS_071_little_crash");
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		if (gameFunc->SetQuake)
			gameFunc->SetQuake(gameFunc->game, 30, 0);
		relax_copunter = 30;
		stateID = 13;
		break;
	case 13:
		if (relax_copunter > 0)
			relax_copunter--;
		else
			stateID = 3;
		break;
	case 14://׹
		ani.image_index = 0;
		vy += 0x20 / ts;
		if (drop_counter > 0)
		{
			drop_counter--;
			cbRect.enableCbRect = false;
			cbRect.enableSoild = false;
		}
		else
		{
			cbRect.enableCbRect = true;
			cbRect.enableSoild = true;
		}
		if (cbRect.enableSoild)
		{
			if (cbRect.cbBottom)
			{
				for (int i = 0; i < 4; i++)
				{
					auto pe = std::make_shared<CS_PeSmoke>();
					pe->x = x + Random(-12, 12);
					pe->y = y + Random(-12, 12);
					pe->vx = Random(-341, 341) / ts;
					pe->vy = Random(-0x600, 0) / ts;
					gameFunc->SetEntity(shared_from_this(), pe);
				}
				gameFunc->PlaySound(L"CS_026_quake");
				if (gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 30, 0);
				stateID = 15;
			}
		}
		//
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (vy < -0x5FF / ts)
			vy = -0x5FF / ts;
		break;
	case 15://
		break;
	case 16://
		stateGravity.Step();
		ani.image_index = 1;
		if (abs(vx) > 0.001f)
			vx /= 1.1f;
		else
			vx = 0;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Enemy_GolemRock::SetState(int stateID, int lr)
{
	this->lr = lr;
	if (stateID < 1000)
	{
		this->stateID = stateID;
		switch (stateID)
		{
		case 3:
			type = 2;//ԭ
			break;
		}
	}
	else
	{
		this->stateID = 14;
		drop_counter = stateID - 1000;
		cbRect.enableCbRect = false;
		cbRect.enableSoild = false;
		//һײ
		Entity::ClearCollisionResult();
	}
}

void CS_Enemy_GolemRock::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, 0);
	else if (stateName == L"wake")
		SetState(1, 0);
	else if (stateName == L"action")
	{
		bAction = true;
		SetState(3, 0);
	}
	else if (stateName == L"action2")
	{
		bAction = true;
		SetState(9, 0);
	}
}

void CS_Enemy_GolemRock::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (!bAction)
		return;
	if (hp <= 0)
		return;
	*outDamage = 10;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x600 / ts;
	if(bNormalMode)
		*outShockForce = 0x300 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_GolemRock::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (!bAction)
		return false;
	if (!bNormalMode)
	{
		if (getDamage < 5)
		{
			*outRealDamage = 0;
			return true;
		}
	}
	if (hp == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
	}
	else
	{
		gameFunc->PlaySound(L"CS_071_little_crash");
		//
		SetCS_PeSmokeMedium(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		stateID = 16;
		damage_reset_counter = -1;
		attackState_reset_counter_max = -1;
		attackState = false;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_GolemRock()
{
	return std::make_shared<CS_Enemy_GolemRock>();
}
