#include "CS_Enemy_GaudiArmoured.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"
#include "CS_AmGaudiArmouredProjectile.h"
CS_Enemy_GaudiArmoured::CS_Enemy_GaudiArmoured()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 8;
	cbRect.top = 11;
	cbRect.bottom = 8;
	hp_max = hp = 15;
	dropExp = 15;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_GaudiArmoured::Init(std::weak_ptr<Entity> self)
{
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_Enemy_GaudiArmoured::Step()
{
	auto& ani_no = ani.image_index;
	stateSplash.Step();
	if (hp > 0)
	{
		switch (act_no)
		{
		case 0:
			tgt_x = x;
			act_no = 1;
			[[fallthrough]];
		case 1:
			ani_no = 0;
			vx = 0;

			if (act_wait < 5)
			{
				++act_wait;
			}
			else
			{
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						if (x - 192*2 < wplayer->x && x + 192*2 > wplayer->x && y - 160 < wplayer->y && y + 160 > wplayer->y)
						{
							act_no = 10;
							act_wait = 0;
							ani_no = 1;
						}
					}
				}
			}
			break;
		case 10:
			if (++act_wait > 3)
			{
				if (++count1 == 3)
				{
					gameFunc->PlaySound(L"CS_030_critter_jump");
					count1 = 0;
					act_no = 25;
					act_wait = 0;
					ani_no = 2;
					vy = -0x600 / ts;
					if (x < tgt_x)
						vx = 0x80 / ts;
					else
						vx = -0x80 / ts;
				}
				else
				{
					gameFunc->PlaySound(L"CS_030_critter_jump");
					act_no = 20;
					ani_no = 2;
					vy = -0x200 / ts;
					if (x < tgt_x)
						vx = 0x200 / ts;
					else
						vx = -0x200 / ts;
				}
			}
			break;
		case 20:
			++act_wait;
			if (cbRect.cbBottom)
			{
				gameFunc->PlaySound(L"CS_023_thud");
				ani_no = 1;
				act_no = 30;
				act_wait = 0;
			}
			break;
		case 25:
			if (++act_wait == 30 || act_wait == 40)
			{
				if (gameFunc->GetPlayerDistance)
				{
					auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
					if (wplayer)
					{
						float dx = wplayer->x - x;
						float dy = wplayer->y - y;
						auto angle = XMConvertToDegrees(XMVectorGetX(XMVector2AngleBetweenVectors(XMVectorSet(1, 0, 0, 0), XMVectorSet(dx, dy, 0, 0))));
						if (dy < 0)
							angle = 360 - angle;
						angle += Random(-6, 6);
						float radian = angle * deg2rad;
						SetCS_AmGaudiArmouredProjectile(shared_from_this(), x, y, 3 * cosf(radian), 3 * sinf(radian));
						gameFunc->PlaySound(L"CS_039_em_fire");
					}
				}
				ani_no = 3;
			}
			if (act_wait == 35 || act_wait == 45)
				ani_no = 2;
			if (cbRect.cbBottom)
			{
				gameFunc->PlaySound(L"CS_023_thud");
				ani_no = 1;
				act_no = 30;
				act_wait = 0;
			}
			break;
		case 30:
			vx = 7 * vx / 8;
			if (++act_wait > 3)
			{
				ani_no = 0;
				act_no = 1;
				act_wait = 0;
			}
			break;
		}
		vy += 51 / ts;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
				lr = wplayer->x < x ? 0 : 1;
		}
		ani.sprite_index = lr == 0 ? L"ls_gaudi_armoured_l" : L"ls_gaudi_armoured_r";
	}
	else
	{
		switch (act_no)
		{
		case 0:
			act_no = 1;
			ani_no = 9;
			vy = -0x200 / ts;
			vx = lr == 0 ? -0x100 / ts : 0x100 / ts;
			gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
			break;
		case 1:
			if (cbRect.cbBottom)
			{
				ani_no = 10;
				ani_wait = 0;
				act_no = 2;
				act_wait = 0;
			}
			break;
		case 2:
			vx = 8 * vx / 9;
			if (++ani_wait > 3)
			{
				ani_wait = 0;
				++ani_no;
			}
			if (ani_no > 11)
				ani_no = 10;
			if (++act_wait > 50)
			{
				gameFunc->PlaySound(L"CS_071_little_crash");
				//
				SetCS_PeSmokeMedium(shared_from_this(), x, y);

				//Ʒ
				SetDropItem(shared_from_this(), x, y, dropExp);
				Destroy();
			}
			break;
		}
		vy += 0x20 / ts;
		ani.sprite_index = lr == 0 ? L"ls_gaudi_l" : L"ls_gaudi_r";
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	if (vy < -0x5FF / ts)
		vy = 0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_Enemy_GaudiArmoured::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_gaudi_armoured_l" : L"ls_gaudi_armoured_r";
}

void CS_Enemy_GaudiArmoured::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (hp <= 0)
		return;
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_GaudiArmoured::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (hp <= 0)
		return false;
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	if (hp <= 0)
	{
		act_no = 0;
		hp = 0;
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_GaudiArmoured()
{
	return std::make_shared<CS_Enemy_GaudiArmoured>();
}
