#include "CS_Enemy_FireSpriteSmall.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_FireSpriteSmall::CS_Enemy_FireSpriteSmall()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.top = cbRect.bottom = 4;
	hp_max = hp = 2;
	dropExp = 1;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
	moveSpeed = 0x500 / ts;
	el.name = CS_ENEMY_FIRESPRITESMALL_CREATENAME;
}

void CS_Enemy_FireSpriteSmall::Init(std::weak_ptr<Entity> self)
{
	//ù
	auto wpeLight = std::make_shared<CS_PeLightFade>();
	peLight = wpeLight;
	gameFunc->SetEntity(shared_from_this(), wpeLight);

	auto wpeLightColor = std::make_shared<CS_PeLightFade>();
	peLightColor = wpeLightColor;
	wpeLightColor->light.usingLight = false;
	if (blue)
		wpeLightColor->color = RGBA(0, 0x98, 0xff, 0x10);
	else
		wpeLightColor->color = RGBA(0xff, 0x98, 0, 0x10);
	gameFunc->SetEntity(shared_from_this(), wpeLightColor);

	wpeLight->SetRadius(5);
	wpeLightColor->SetRadius(5);
	wpeLight->last_x = wpeLight->x = x;
	wpeLight->last_y = wpeLight->y = y;
	wpeLightColor->last_x = wpeLightColor->x = x;
	wpeLightColor->last_y = wpeLightColor->y = y;
	Entity::Init(self);
}

void CS_Enemy_FireSpriteSmall::Step()
{
	
	//ǽ
	if (cbRect.cbLeft)
	{
		vx = 1;
		lr = 1;
	}
	else if (cbRect.cbRight)
	{
		vx = -1;
		lr = 0;
	}
	else if (cbRect.cbTop)
		vy = 1;
	else if (cbRect.cbBottom)
		vy = -1;
	if (vx != 0 || vy != 0)
		SetDir(SpeedGetDir());
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	auto wpeLight = peLight.lock();
	if (wpeLight)
	{
		wpeLight->x = x;
		wpeLight->last_x = last_x;
		wpeLight->y = y;
		wpeLight->last_y = last_y;
	}
	auto wpeLightColor = peLightColor.lock();
	if (wpeLightColor)
	{
		wpeLightColor->x = x;
		wpeLightColor->last_x = last_x;
		wpeLightColor->y = y;
		wpeLightColor->last_y = last_y;
	}
	//ˮ
	if (cbRect.inWater)
	{
		int out;
		Hurt(std::weak_ptr<Entity>(), 127, 0, false, 0, 0, 0, &out);
	}
	//ͼʧ
	if (IsOutOfMap(128))
		Destroy();
}

void CS_Enemy_FireSpriteSmall::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_FireSpriteSmall::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_104");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		hp = 0;
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

void CS_Enemy_FireSpriteSmall::Destroy()
{
	auto wpeLight = peLight.lock();
	if (wpeLight)
		wpeLight->Destroy();
	auto wpeLightColor = peLightColor.lock();
	if (wpeLightColor)
		wpeLightColor->Destroy();
	Entity::Destroy();
}

void CS_Enemy_FireSpriteSmall::Feedback(std::weak_ptr<Entity> target)
{
	gameFunc->PlaySound(L"CS_070_expl_small");
	//
	SetCS_PeSmokeSmall(shared_from_this(), x, y);
	Destroy();
}

void CS_Enemy_FireSpriteSmall::SetDir(int dirNum)
{
	switch (dirNum)
	{
	case 7:
		lr = 0;
		vx = moveSpeed * cosf(225 * deg2rad);
		vy = moveSpeed * sinf(225 * deg2rad);
		if (blue)
			ani.sprite_index = L"ls_firesprite_blue_small_l7";
		else
			ani.sprite_index = L"ls_firesprite_red_small_l7";
		break;
	case 8:
		vx = moveSpeed * cosf(270 * deg2rad);
		vy = moveSpeed * sinf(270 * deg2rad);
		if (blue)
			ani.sprite_index = lr == 0 ? L"ls_firesprite_blue_small_l8" : L"ls_firesprite_blue_small_r8";
		else
			ani.sprite_index = lr == 0 ? L"ls_firesprite_red_small_l8" : L"ls_firesprite_red_small_r8";
		break;
	case 9:
		lr = 1;
		vx = moveSpeed * cosf(315 * deg2rad);
		vy = moveSpeed * sinf(315 * deg2rad);
		if (blue)
			ani.sprite_index = L"ls_firesprite_blue_small_r9";
		else
			ani.sprite_index = L"ls_firesprite_red_small_r9";
		break;
	case 4:
		lr = 0;
		vx = moveSpeed * cosf(180 * deg2rad);
		vy = moveSpeed * sinf(180 * deg2rad);
		if (blue)
			ani.sprite_index = L"ls_firesprite_blue_small_l4";
		else
			ani.sprite_index = L"ls_firesprite_red_small_l4";
		break;
	case 6:
		lr = 1;
		vx = moveSpeed * cosf(0 * deg2rad);
		vy = moveSpeed * sinf(0 * deg2rad);
		if (blue)
			ani.sprite_index = L"ls_firesprite_blue_small_r6";
		else
			ani.sprite_index = L"ls_firesprite_red_small_r6";
		break;
	case 1:
		lr = 0;
		vx = moveSpeed * cosf(135 * deg2rad);
		vy = moveSpeed * sinf(135 * deg2rad);
		if (blue)
			ani.sprite_index = L"ls_firesprite_blue_small_l1";
		else
			ani.sprite_index = L"ls_firesprite_red_small_l1";
		break;
	case 2:
		vx = moveSpeed * cosf(90 * deg2rad);
		vy = moveSpeed * sinf(90 * deg2rad);
		if (blue)
			ani.sprite_index = lr == 0 ? L"ls_firesprite_blue_small_l2" : L"ls_firesprite_blue_small_r2";
		else
			ani.sprite_index = lr == 0 ? L"ls_firesprite_red_small_l2" : L"ls_firesprite_red_small_r2";
		break;
	case 3:
		lr = 1;
		vx = moveSpeed * cosf(45 * deg2rad);
		vy = moveSpeed * sinf(45 * deg2rad);
		if (blue)
			ani.sprite_index = L"ls_firesprite_blue_small_r3";
		else
			ani.sprite_index = L"ls_firesprite_red_small_r3";
		break;
	}
	if (abs(vx) < 0.001f)
		vx = 0;
	if (abs(vy) < 0.001f)
		vy = 0;
}

int CS_Enemy_FireSpriteSmall::SpeedGetDir()
{
	if (vy < 0)
	{
		if (vx < 0)
			return 7;
		else if (vx == 0)
			return 8;
		else
			return 9;
	}
	else if (vy == 0)
	{
		if (vx < 0)
			return 4;
		else
			return 6;
	}
	else
	{
		if (vx < 0)
			return 1;
		else if (vx == 0)
			return 2;
		else
			return 3;
	}
}

void CS_Enemy_FireSpriteSmall::SetBlue()
{
	blue = true;
}
