#include "CS_Enemy_BlackBat_Hanging.h"
#include "CS_PeSmoke.h"
#include "CS_Exp.h"

CS_Enemy_BlackBat_Hanging::CS_Enemy_BlackBat_Hanging()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 4;
	cbRect.top = 7;
	cbRect.bottom = 4;
	cbRect.waterBlock = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(2);
	ani.hideLayerList.insert(3);
	hp_max = hp = 4;
	dropExp = 3;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Enemy_BlackBat_Hanging::Step()
{
	switch (act_no)
	{
	case 0:
		act_no = 1;
		[[fallthrough]];
	case 1:
		if (Random(0, 120) == 10)
		{
			act_no = 2;
			act_wait = 0;
			ani_no = 1;
		}
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (x - 0x1000 / ts < wplayer->x && x + 0x1000 / ts > wplayer->x && y - 0x1000 / ts < wplayer->y && y + 0xC000 / ts > wplayer->y)
				{
					ani_no = 0;
					act_no = 3;
				}
			}
		}
		break;
	case 2:
		if (++act_wait > 8)
		{
			act_no = 1;
			ani_no = 0;
		}
		break;
	case 3:
		ani_no = 0;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (shock_counter > 0 || x - 0x2800 / ts > wplayer->x || x + 0x2800 / ts < wplayer->x)
				{
					ani_no = 1;
					ani_wait = 0;
					act_no = 4;
					act_wait = 0;
				}
			}
		}
		break;
	case 4:
		vy += 0x20 / ts;
		if (vy > 0x5FF / ts)
			vy = 0x5FF / ts;
		if (++act_wait < 20 && !cbRect.cbBottom)
			break;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (cbRect.cbBottom || y > wplayer->y - 0x2000 / ts)
				{
					ani_wait = 0;
					ani_no = 2;
					act_no = 5;
					tgt_y = y;
					if (cbRect.cbBottom)
						vy = -0x200 / ts;
				}
			}
		}
		break;
	case 5:
		if (++ani_wait > 1)
		{
			ani_wait = 0;
			++ani_no;
		}
		if (ani_no > 4)
			ani_no = 2;
		if (gameFunc->GetPlayerDistance)
		{
			auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
			if (wplayer)
			{
				if (wplayer->x < x)
				{
					lr = 0;
					vx -= 0x10 / ts;
				}
				else
				{
					lr = 1;
					vx += 0x10 / ts;
				}
			}
		}
		if (tgt_y < y)
			vy -= 0x10 / ts;
		if (tgt_y > y)
			vy += 0x10 / ts;
		if (vx > 0x200 / ts)
			vx = 0x200 / ts;
		if (vx < -0x200 / ts)
			vx = -0x200 / ts;
		if (vy > 0x200 / ts)
			vy = 0x200 / ts;
		if (vy < -0x200 / ts)
			vy = -0x200 / ts;
		if (cbRect.cbBottom)
			vy = -0x200 / ts;
		if (cbRect.cbTop)
			vy = 0x200 / ts;
		break;
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	switch (ani_no)
	{
	case 0:
	case 1:
		ani.sprite_index = lr == 0 ? L"ls_bat_sleep_l" : L"ls_bat_sleep_r";
		ani.image_index = ani_no;
		break;
	case 2:
	case 3:
	case 4:
		ani.sprite_index = lr == 0 ? L"ls_bat_fly_l" : L"ls_bat_fly_r";
		ani.image_index = ani_no - 2;
		break;
	}
}

void CS_Enemy_BlackBat_Hanging::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_bat_sleep_l" : L"ls_bat_sleep_r";
}

void CS_Enemy_BlackBat_Hanging::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 2;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_Enemy_BlackBat_Hanging::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_055_enemy_squeak2");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		//Ʒ
		SetDropItem(shared_from_this(), x, y, dropExp);
		Destroy();
	}
	//˺
	if (shockForce > 0)
	{
		//
		float radian = angle * deg2rad;
		vx = shockForce * cosf(radian);
		vy = shockForce * sinf(radian);
		vy -= 1;
	}
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y - 16, 0, shared_from_this());
	return true;
}

std::shared_ptr<Entity> CreateCS_Enemy_BlackBat_Hanging()
{
	return std::make_shared<CS_Enemy_BlackBat_Hanging>();
}
