#include "CS_CurlyMachineGunBlade.h"
#include "CS_PeGunShotSpark.h"
#include "CS_PeGunShotHit.h"
#include "CS_PeHurt.h"
CS_CurlyMachineGunBlade::CS_CurlyMachineGunBlade(std::shared_ptr<Entity> parent, int range)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.ignoreMovePlatform = true;
	cbRect.left = 2;
	cbRect.right = 2;
	cbRect.top = 2;
	cbRect.bottom = 2;
	cbRect.breakStarBlock = true;
	//÷ͳʼλ
	ud = parent->ud;
	lr = parent->lr;
	if (ud == -1)
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y - 8;
		vx = Random(-range, range) / ts;
		vy = -move;
		SetCS_PeGunShotSpark(parent, x, y);
		ani.sprite_index = L"am_machinegun_u";
	}
	else if (ud == 0)
	{
		y = parent->y + 3;
		if (lr == 0)
		{
			x = parent->x - 6;
			SetCS_PeGunShotSpark(parent, parent->x - 0x1800 / ts, y);
			ani.sprite_index = L"am_machinegun_l";
		}
		else
		{
			x = parent->x + 6;
			SetCS_PeGunShotSpark(parent, parent->x + 0x1800 / ts, y);
			ani.sprite_index = L"am_machinegun_r";
		}
		vx = lr == 0 ? -move : move;
		vy = Random(-range, range) / ts;
	}
	else
	{
		if (lr == 0)
			x = parent->x - 1;
		else
			x = parent->x + 1;
		y = parent->y + 8;
		vx = Random(-range, range) / ts;
		vy = move;
		SetCS_PeGunShotSpark(parent, x, y);
		ani.sprite_index = L"am_machinegun_d";
	}
	//Ч
	parent->gameFunc->PlaySound(L"CS_049_polar_star_l3");
	//ʱ
	action_timecounter_max = 20;
	action_timecounter = action_timecounter_max;
}

void CS_CurlyMachineGunBlade::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	//ͼ
	if (ani.png.length() == 0)
		ani.png = L"CS_CaveStoryMod";
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();//
	//ִײ
	Entity::Collision();
	//ٶ
	if (vx == 0 || vy == 0)
	{
		if (ud == -1)
			vy = -move;
		else if (ud == 0)
			vx = lr == 0 ? -move : move;
		else
			vy = move;
	}
	//ʧ
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
		}
	}
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		gameFunc->PlaySound(L"CS_028_shot_hit");
		SetCS_PeGunShotHit(shared_from_this(), x, y);
		Destroy();
	}
}

void CS_CurlyMachineGunBlade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 6;
	if (lr == 0)
	{
		*outAngle = 270;
	}
	else
	{
		*outAngle = 270;
	}
	*outTakedown = false;
	*outElemType = 0;
	*outShockForce = 0 / ts;
	*outHeavy = 0;
}

void CS_CurlyMachineGunBlade::AttackEffectObject(std::weak_ptr<Entity> target, float centerX, float centerY, int realDamage)
{
	if (realDamage == 0)
	{
		gameFunc->PlaySound(L"CS_031_shot_bounce");
		SetCS_PeGunShotHit(shared_from_this(), centerX, centerY);
	}
	else
	{
		auto wtarget = target.lock();
		if (wtarget)
		{
			if (wtarget->hp > 0)
				SetCS_PeHurt_Num3(shared_from_this(), centerX, centerY);
		}
	}
}

void CS_CurlyMachineGunBlade::Feedback(std::weak_ptr<Entity> target)
{
	Destroy();
}