#include "CS_CurlyHurt.h"
#include "CS_Curly.h"
const int CS_CurlySTATENAME_HURT = ++entityStateID;
CS_CurlyHurt::CS_CurlyHurt()
{
	stateID = CS_CurlySTATENAME_HURT;
}

void CS_CurlyHurt::State()
{
	auto we = e.lock();
	if (!we)
		return;

	auto mychar = std::static_pointer_cast<CS_Curly>(we);
	if (mychar->fishState)
		we->ani.sprite_index = we->lr == 0 ? L"mc_curlyfish_hurt_l" : L"mc_curlyfish_hurt_r";
}

void CS_CurlyHurt::ChangeStateMsg(int stateID)
{
	if (stateID == GetStateID())
	{
		auto we = e.lock();
		if (!we)
			return;

		auto mychar = std::static_pointer_cast<CS_Curly>(we);
		enable = true;
		if (mychar->fishState)
		{
			mychar->action_timecounter = 30;
		}
		else
		{
			mychar->vy = -0x400 / ts;
			mychar->stateInvincible.SetInvincible(180);
		}
	}
	else
		enable = false;
}
