#include "CS_Credit_Ending.h"

CS_Credit_Ending::CS_Credit_Ending()
{
	ani.sprite_index = L"ending";
	topDraw = true;
}

void CS_Credit_Ending::Step()
{
	const float speed = 0x1000 / ts;
	if (delayTime > 0)
	{
		delayTime--;
		if (delayTime == 0)
		{
			ani.png = L"CS_Ending";
		}
	}
	else if (moveInCounter > 0)
	{
		moveInCounter--;
		vx = speed;
	}
	else if (pauseCounter > 0)
	{
		pauseCounter--;
		vx = 0;
	}
	else if (moveOutCounter > 0)
	{
		moveOutCounter--;
		vx = -speed;
	}
	else
		Destroy();
	//ִ˶
	Entity::Step();
}

void CS_Credit_Ending::SetState(int stateID, int lr)
{
	ani.image_index = stateID;
	delayTime = lr;
}

void CS_Credit_Ending::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"set_moveIn")
		moveInCounter = lr;
	if (stateName == L"set_pause")
		pauseCounter = lr;
	if (stateName == L"set_moveOut")
		moveOutCounter = lr;
}

std::shared_ptr<Entity> CreateCS_Credit_Ending()
{
	return std::make_shared<CS_Credit_Ending>();
}
