#include "CS_ColonAni.h"
#include "CS_PeZzz.h"
CS_ColonAni::CS_ColonAni()
{
	ani.png = L"CS_CaveStoryMod";
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	//ײ
	cbRect.left = cbRect.right = 5;
	cbRect.top = 6;
	cbRect.bottom = 8;
}

void CS_ColonAni::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	Entity::Init(self);
}

void CS_ColonAni::Step()
{
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateGravity.Step();
	switch (stateID)
	{
	case 0://վ
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 3://£ڴϣ
	case 4:
		vx = 0;
		vy = 0;
		//zzz
		if (++act_wait > 100)
		{
			act_wait = 0;
			SetPeCS_Zzz(shared_from_this(), x, y);
		}
		break;
	case 5:
	case 6://
		vx = 0;
		vy = 0;
		//գ
		if (Random(0, 120) == 10)
		{
			wink_counter = 8;
		}
		if (wink_counter > 0)
		{
			wink_counter--;
			ani.image_index = 1;
		}
		else
		{
			ani.image_index = 0;
		}
		break;
	case 7://˯ڴϣ
	case 8:
		vx = 0;
		vy = 0;
		//zzz
		if (++act_wait > 100)
		{
			act_wait = 0;
			SetPeCS_Zzz(shared_from_this(), x, y);
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ӳһ֡
	if (animation_delay)
		animation_delay = false;
	else
		Entity::Step();//ִ˶
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_ColonAni::SetState(int stateID, int lr)
{
	if (stateID < 200)
	{
		this->lr = lr;
		this->stateID = stateID;
		//ö
		switch (stateID)
		{
		case 0://վ
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_colon_stand_l" : L"mc_colon_stand_r";
			break;
		case 1://·
			{
				animation_delay = true;
				if (lr == 0)
					vx = -animation_moveSpeed;
				else
					vx = animation_moveSpeed;
				ani.sprite_index = lr == 0 ? L"mc_colon_move_l" : L"mc_colon_move_r";
			}
			break;
		case 2://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_colon_back_l" : L"mc_colon_back_r";
			break;
		case 3://£ڴϣ
			y -= 6;
			x -= 9;
			vx = 0;
			vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_colon_lie_l" : L"mc_colon_lie_r";
			break;
		case 4:
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_colon_lie_l" : L"mc_colon_lie_r";
			break;
		case 5://
			vx = 0;
			ani.sprite_index = lr == 0 ? L"mc_colon_sit_l" : L"mc_colon_sit_r";
			break;
		case 6://
			vx = 0;
			y -= 3;
			ani.sprite_index = lr == 0 ? L"mc_colon_sit_l" : L"mc_colon_sit_r";
			break;
		case 7://˯ڴϣ
			y -= 6;
			x -= 9;
			vx = 0;
			vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_colon_sleep_l" : L"mc_colon_sleep_r";
			break;
		case 8://˯ڵذϣ
			vx = 0;
			vy = 0;
			ani.sprite_index = lr == 0 ? L"mc_colon_sleep_l" : L"mc_colon_sleep_r";
			break;
		}
	}
}

void CS_ColonAni::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"normal")
		SetState(0, lr);
	else if (stateName == L"walk")
		SetState(1, lr);
	else if (stateName == L"back")
		SetState(2, lr);
	else if (stateName == L"lie")
		SetState(3, lr);
	else if (stateName == L"sleep_on_bed")
		SetState(7, lr);
	else if (stateName == L"sit")
		SetState(5, lr);
	else if (stateName == L"sit_on_chair")
		SetState(6, lr);
	else if (stateName == L"sleep")
		SetState(8, lr);
}

std::shared_ptr<Entity> CreateCS_ColonAni()
{
	return std::make_shared<CS_ColonAni>();
}
