#include "CS_Boss_Tala_AtkZone.h"

CS_Boss_Tala_AtkZone::CS_Boss_Tala_AtkZone(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	cbRect.left = cbRect.right = 12;
	cbRect.top = 32;
	cbRect.bottom = 8;
	damage_reset_counter = 60;
	attackState_reset_counter_max = 60;
}

void CS_Boss_Tala_AtkZone::Step()
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		ignoreCaught_counter = wattackParent->ignoreCaught_counter;
		damage_reset_counter = wattackParent->damage_reset_counter;
		attackState_reset_counter_max = wattackParent->attackState_reset_counter_max;
		attackState = wattackParent->attackState;
	}
}

std::weak_ptr<Entity> CS_Boss_Tala_AtkZone::BeginCaught(std::weak_ptr<Entity> e)
{
	return attackParent;
}

void CS_Boss_Tala_AtkZone::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	auto wattackParent = attackParent.lock();
	if (wattackParent)
	{
		if(wattackParent->hp > 0)
			*outDamage = 1;
		else
			*outDamage = 0;
	}
	else
		*outDamage = 1;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}
