#include "CS_Boss_Honeycomb.h"
#include "CS_PeSmoke.h"
#include "CS_Enemy_Bee.h"
CS_Boss_Honeycomb::CS_Boss_Honeycomb()
{
	type = 2;
	ani.png = L"CS_CaveStoryMod";
	cbRect.enableCbRect = true;
	cbRect.left = cbRect.right = 48;
	float offY = 92;
	cbRect.top = 16 - offY;
	cbRect.bottom = 16 + offY;
	ani.sprite_index = L"ls_honeycomb_close";
	hp = 100;
	drawBeforeOtherEntity = true;
	ignoreCaught = true;
	ani.hideLayerList.insert(0);
	ani.hideLayerList.insert(1);
}

void CS_Boss_Honeycomb::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	Entity::Init(self);
}

void CS_Boss_Honeycomb::Step()
{
	if (hp == 0 && explodeCounter > 0)
	{
		if (explodeCounter % 8 == 0)
			gameFunc->PlaySound(L"CS_052_enemy_hurt_big");
		explodeCounter--;
		SetCS_PeSmoke2(shared_from_this(), x, y);
		if(explodeCounter == 0)
		{
			gameFunc->PlaySound(L"CS_035_explosion1");
			ani.sprite_index = L"ls_honeycomb_destroy";
		}
	}
	if (flash > 0)
		flash--;
	if (hp > 0 && stateID == 1)
	{
		//۷
		if (beeSetNum_counter > 0)
		{
			if (beeSetInterval_counter > 0)
				beeSetInterval_counter--;
			if (beeSetInterval_counter == 0)
			{
				beeSetInterval_counter = beeSetInterval_counter_max;
				if (bNormalMode)
				{
					if (Random(0, 10) < 5)
					{
						auto e = std::make_shared<CS_Enemy_Bee>();
						e->x = x + Random((int)-cbRect.left, (int)cbRect.right);
						e->y = y + 92;
						gameFunc->SetEntity(shared_from_this(), e);
					}
				}
				else
				{
					auto e = std::make_shared<CS_Enemy_Bee>();
					e->x = x + Random((int)-cbRect.left, (int)cbRect.right);
					e->y = y + 92;
					gameFunc->SetEntity(shared_from_this(), e);
				}
				beeSetNum_counter--;
			}
		}
		if (beeSet_counter > 0)
			beeSet_counter--;
		if (beeSet_counter == 0)
		{
			beeSet_counter = beeSet_counter_max;
			beeSetNum_counter = beeSetNum;
		}
		ani.sprite_index = flash > 0 ? L"ls_honeycomb_hurt" : L"ls_honeycomb_open";
	}
}

void CS_Boss_Honeycomb::SetState(int stateID, int lr)
{
	this->lr = lr;
	ani.sprite_index = lr == 0 ? L"ls_honeycomb_close" : L"ls_honeycomb_destroy";
	if (lr != 0)
		type = 0;
}

void CS_Boss_Honeycomb::SetState(std::wstring stateName, int lr)
{
	this->lr = lr;
	if (stateName == L"close")
	{
		stateID = 0;
		gameFunc->PlaySound(L"CS_115_core_thrust");
		ani.sprite_index = L"ls_honeycomb_close";
		for (size_t i = 0; i < 8; i++)
		{
			int offset_x = Random((int)-cbRect.left, (int)cbRect.right);
			int offset_y = Random((int)-cbRect.top, (int)cbRect.bottom);
			auto e = std::make_shared<CS_PeSmoke>();
			e->x = x + offset_x;
			e->y = y + offset_y;
			gameFunc->SetEntity(shared_from_this(), e);
		}
	}
	else if (stateName == L"open")
	{
		stateID = 1;
		gameFunc->PlaySound(L"CS_115_core_thrust");
		ani.sprite_index = L"ls_honeycomb_open";
		for (size_t i = 0; i < 8; i++)
		{
			int offset_x = Random((int)-cbRect.left, (int)cbRect.right);
			int offset_y = Random((int)-cbRect.top, (int)cbRect.bottom);
			auto e = std::make_shared<CS_PeSmoke>();
			e->x = x + offset_x;
			e->y = y + offset_y;
			gameFunc->SetEntity(shared_from_this(), e);
		}
		beeSet_counter = 30;
	}
	else if (stateName == L"defeated")
	{
		type = 0;
		explodeCounter = 100;
		hp = 0;
	}
	else if (stateName == L"secondState")
	{
		beeSetNum = 8;
		beeSet_counter_max = 300;
	}
}

bool CS_Boss_Honeycomb::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (lr != 0)
		return false;
	if (stateID == 0)
	{
		*outRealDamage = 0;
		return true;
	}
	flash = 10;
	//ʾ˺ֵ
	if (gameFunc->dmgNum)
		gameFunc->SetDmgNum(gameFunc->dmgNum, getDamage, x, y + 64, 0, shared_from_this());
	//˺תƵƺ
	auto wcontrolCore = controlCore.lock();
	if (wcontrolCore)
		return wcontrolCore->Hurt(src, getDamage, angle, bTakedown, elemType, shockForce, shockForce, outRealDamage);
	return true;
}

std::shared_ptr<Entity> CreateCS_Boss_Honeycomb()
{
	return std::make_shared<CS_Boss_Honeycomb>();
}
