#include "CS_AmSoundWaveBase.h"
#include "CS_AmSoundWave.h"
CS_AmSoundWaveBase::CS_AmSoundWaveBase(std::shared_ptr<Entity> parent)
{
	attackParent = parent;
	action_timecounter = action_timecounter_max = 10;
}

void CS_AmSoundWaveBase::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	if (bNormalMode)
		existTime = 150;
	ActionEntity::Init(self);
}

void CS_AmSoundWaveBase::Step()
{
	if (existTime > 0)
		existTime--;
	if (existTime == 0)
		Destroy();
	if (action_timecounter > 0)
		action_timecounter--;
	if (action_timecounter == 0)
	{
		action_timecounter = action_timecounter_max;
		auto am = std::make_shared<CS_AmSoundWave>(attackParent.lock());
		am->x = x;
		am->y = y;
		gameFunc->SetEntity(shared_from_this(), am);
	}
}

std::shared_ptr<Entity> CreateCS_AmSoundWaveBase()
{
	return std::make_shared<CS_AmSoundWaveBase>(nullptr);
}
