#include "CS_AmRedDemon.h"
#include "CS_PeSmoke.h"

CS_AmRedDemon::CS_AmRedDemon(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	lr = parent->lr;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_reddemon";
	//
	speedDir = true;
}

void CS_AmRedDemon::Step()
{
	auto& ani_no = ani.image_index;
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		for (auto i = 0; i < 3; i++)
		{
			auto pe = CreateCS_PeSmoke();
			pe->x = x;
			pe->y = y;
			gameFunc->SetEntity(shared_from_this(), pe);
		}
		Destroy();
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//
	if (++act_wait % 5 == 0)
		gameFunc->PlaySound(L"CS_110");
	if (++ani_no > 2)
		ani_no = 0;
}

void CS_AmRedDemon::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 6;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_AmRedDemon::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void SetCS_AmRedDemon(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmRedDemon>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	am->lr = vx < 0 ? 0 : 1;
	parent->gameFunc->SetEntity(parent, am);
}
