#include "CS_AmMonsterXPawD.h"
#include <PeSmog.h>

CS_AmMonsterXPawD::CS_AmMonsterXPawD(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = 32;
	cbRect.top = 32;
	cbRect.bottom = 8;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_monsterx_paw_d";
	color = RGBA(0xff, 0xff, 0xff, (BYTE)(appear_counter * 0xff / appear_counter_max));
}

void CS_AmMonsterXPawD::Init(std::weak_ptr<Entity> self)
{
	if (gameFunc->pGameOption_difficulty)
		if (*gameFunc->pGameOption_difficulty == 0)
			bNormalMode = true;
	Entity::Init(self);
}

void CS_AmMonsterXPawD::Step()
{
	switch (stateID)
	{
	case 0://
		if (appear_counter < appear_counter_max)
		{
			appear_counter++;
		}
		else
		{
			stateID = 1;
			//Ч
			auto wlightTail = std::make_shared<PeLightTail>(shared_from_this(), 40, 64.0f);
			lightTail = wlightTail;
			gameFunc->SetEntity(shared_from_this(), wlightTail);
		}
		color = RGBA(0xff, 0xff, 0xff, (BYTE)(appear_counter * 0xff / appear_counter_max));
		break;
	case 1://ɨ
		if (cbRect.cbBottom)
		{
			if (bAngryAttack)
			{
				if(gameFunc->SetQuake)
					gameFunc->SetQuake(gameFunc->game, 20, 0);
				gameFunc->PlaySound(L"CS_026_quake");
				SetPeSmog(shared_from_this(), x, y, 1, 1, 135);
				SetPeSmog(shared_from_this(), x, y, 1, 1, 45);
			}
			stateID = 2;
			auto wlightTail = lightTail.lock();
			if (wlightTail)
				wlightTail->Leave();
			lightTail.reset();
		}
		vy = 0x1800 / ts;
		if(bNormalMode)
			vy = 0xc00 / ts;
		break;
	case 2://ʧ
		vx = 0;
		vy = 0;
		if (appear_counter > 0)
		{
			appear_counter--;
		}
		else
		{
			Destroy();
		}
		color = RGBA(0xff, 0xff, 0xff, (BYTE)(appear_counter * 0xff / appear_counter_max));
		break;
	}
	float srcX = x;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	x = srcX;
}

void CS_AmMonsterXPawD::SetState(std::wstring stateName, int lr)
{
	if (stateName == L"angry_attack")
	{
		vy = 0x1800 / ts;
		if (bNormalMode)
			vy = 0xc00 / ts;
		bAngryAttack = true;
		appear_counter_max = 10;
	}
}

void CS_AmMonsterXPawD::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	if (stateID == 1)
	{
		*outDamage = 10;
		if (lr == 0)
			*outAngle = 225;
		else
			*outAngle = 315;
		*outTakedown = true;
		*outElemType = 0;
		*outShockForce = 0x800 / ts;
		if(bNormalMode)
			*outShockForce = 0x400 / ts;
		*outHeavy = 2;
	}
}

bool CS_AmMonsterXPawD::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	*outRealDamage = 0;
	return true;
}

std::shared_ptr<Entity> CreateCS_AmMonsterXPawD()
{
	return std::make_shared<CS_AmMonsterXPawD>(nullptr);
}
