#include "CS_AmGrenade.h"
#include "CS_PeSmoke.h"

CS_AmGrenade::CS_AmGrenade(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	lr = parent->lr;
	hp = 10;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_grenade";
	//
	noDir = true;
	attackState = false;
}

void CS_AmGrenade::Step()
{
	if (bExplode)
	{
		Destroy();
		return;
	}
	auto& ani_no = ani.image_index;
	if (gameFunc->GetPlayerDistance)
	{
		auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
		if (wplayer)
		{
			if (abs(x - wplayer->x) <= 16 && abs(y - wplayer->y) <= 16)
				Explode();
		}
	}
	//ǽ
	BOOL bHit;
	switch (act_no)
	{
	case 0:
		[[fallthrough]];
	case 1:
		bHit = FALSE;
		if (cbRect.cbLeft)
		{
			bHit = TRUE;
			vx = 0x200 / ts;
		}
		if (cbRect.cbRight)
		{
			bHit = TRUE;
			vx = -0x200 / ts;
		}
		if (cbRect.cbTop)
		{
			bHit = TRUE;
			vy = 0x200 / ts;
		}
		if (cbRect.cbBottom)
		{
			bHit = TRUE;
			vy = -0x200 / ts;
		}
		if (bHit)
		{
			act_no = 2;
			++count1;
			gameFunc->PlaySound(L"CS_031_shot_bounce");
		}
		break;
	case 2:
		vy += 0x40 / ts;
		if (cbRect.cbBottom)
		{
			if (++count1 > 1)
			{
				Explode();
			}
		}
		break;
	}
	if (vy > 0x5FF / ts)
		vy = 0x5FF / ts;
	if (vy < -0x5FF / ts)
		vy = -0x5FF / ts;
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//
	if (++act_wait % 5 == 0)
		gameFunc->PlaySound(L"CS_110");
	if (++ani_no > 2)
		ani_no = 0;
}

void CS_AmGrenade::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 20;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

void CS_AmGrenade::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

bool CS_AmGrenade::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	shock_counter = 30;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_054_enemy_hurt_cool");
	}
	else
	{
		Explode();
	}
	return true;
}

void CS_AmGrenade::Explode()
{
	attackState = true;
	cbRect.left = cbRect.right = 64;
	cbRect.top = cbRect.bottom = 50;
	gameFunc->PlaySound(L"CS_071_little_crash");
	SetCS_PeSmoke(shared_from_this(), x, y, 100);
	bExplode = true;
	ani.png = L"";
}

void SetCS_AmGrenade(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmGrenade>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	am->lr = vx < 0 ? 0 : 1;
	parent->gameFunc->SetEntity(parent, am);
}
