#include "CS_AmGaudiProjectile.h"
#include "CS_PeSmoke.h"
#include "CS_PePhoton.h"

CS_AmGaudiProjectile::CS_AmGaudiProjectile(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 4;
	hp_max = hp = 1;
	//ö
	ani.png = L"CS_CaveStoryMod";
	//
	speedDir = true;
}

void CS_AmGaudiProjectile::Step()
{
	//ǽʧ
	if (cbRect.enableSoild)
	{
		cbRect.enableSoild = false;
	}
	else if (cbRect.cbLeft || cbRect.cbRight || cbRect.cbTop || cbRect.cbBottom)
	{
		SetCS_PePhoton(shared_from_this(), x, y);
		Destroy();
	}
	if (++count1 > 300)
	{
		SetCS_PePhoton(shared_from_this(), x, y);
		Destroy();
	}
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Collision();
	//
	ani.sprite_index = lr == 0 ? L"am_gaudi_l" : L"am_gaudi_r";
}

void CS_AmGaudiProjectile::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 3;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmGaudiProjectile::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_021_bubble");
	}
	else
	{
		gameFunc->PlaySound(L"CS_021_bubble");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	return true;
}

void CS_AmGaudiProjectile::Collision()
{
	float srcVx = vx;
	float srcVy = vy;
	Entity::Collision();
	vx = srcVx;
	vy = srcVy;
}

void SetCS_AmGaudiProjectile(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmGaudiProjectile>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	am->lr = vx < 0 ? 0 : 1;
	parent->gameFunc->SetEntity(parent, am);
}
