#include "CS_AmBuyoBuyoBounce.h"
#include "CS_PeSmoke.h"
#include "CS_PeGunShotSpark.h"
CS_AmBuyoBuyoBounce::CS_AmBuyoBuyoBounce(std::shared_ptr<Entity> parent)
{
	type = 2;
	attackParent = parent;
	lr = parent->lr;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	cbRect.left = cbRect.right = cbRect.bottom = cbRect.top = 6;
	hp_max = hp = 6;
	dropExp = 3;
	//ö
	ani.png = L"CS_CaveStoryMod";
	ani.sprite_index = L"am_buyobuyo_bounce";
	//
	speedDir = true;
}

void CS_AmBuyoBuyoBounce::Init(std::weak_ptr<Entity> self)
{
	stateGravity.Init(shared_from_this());
	stateResist.Init(shared_from_this());
	stateSplash.Init(shared_from_this());
	Entity::Init(self);
}

void CS_AmBuyoBuyoBounce::Step()
{
	if (attackParent.expired())
	{
		SetCS_PeGunShotSpark(shared_from_this(), x, y);
		Destroy();
		return;
	}
	else
	{
		auto wattackParent = attackParent.lock();
		if (wattackParent->hp == 0)
		{
			SetCS_PeGunShotSpark(shared_from_this(), x, y);
			Destroy();
			return;
		}
	}
	if (exist_counter > 0)
		exist_counter--;
	if (lr == 0 && cbRect.cbLeft || lr != 0 && cbRect.cbRight || exist_counter == 0)
	{
		SetCS_PeGunShotSpark(shared_from_this(), x, y);
		Destroy();
		return;
	}
	//ƶƽ̨
	Entity::BeginMovingPlatform();
	stateResist.apply_resistH = cbRect.cbBottom;
	stateGravity.Step();
	stateResist.Step();
	stateSplash.Step();
	switch (stateID)
	{
	case 0:
		ani.image_index = 0;
		if (++action_timecounter > 8 && cbRect.cbBottom)
		{
			if (gameFunc->GetPlayerDistance)
			{
				auto wplayer = gameFunc->GetPlayerDistance(gameFunc->game, x, y).lock();
				if (wplayer)
					lr = x > wplayer->x ? 0 : 1;
			}
			vy = -0x5FF / ts;
			vx = lr == 0 ? -0x200 / ts : 0x200 / ts;
			stateID = 1;
		}
		break;
	case 1: // Jumping
		ani.image_index = 1;
		if (cbRect.cbBottom)
		{
			vx = 0;
			stateID = 0;
			action_timecounter = 0;
		}
		break;
	}
	//ƶƽ̨
	Entity::EndMovingPlatform();
	//һײ
	Entity::ClearCollisionResult();
	//ִ˶
	Entity::Step();
	//ִײ
	Entity::Collision();
	//άб
	Entity::KeepOnSlopes();
}

void CS_AmBuyoBuyoBounce::Attack(std::weak_ptr<Entity> dst, int* outDamage, float* outAngle, bool* outTakedown, int* outElemType, float* outShockForce, float* outHeavy)
{
	*outDamage = 5;
	auto wdst = dst.lock();
	if (wdst)
	{
		if (wdst->lr == 0)
		{
			*outAngle = 315;
		}
		else
		{
			*outAngle = 225;
		}
	}
	*outTakedown = true;
	*outElemType = 0;
	*outShockForce = 0x200 / ts;
	*outHeavy = 2;
}

bool CS_AmBuyoBuyoBounce::Hurt(std::weak_ptr<Entity> src, int getDamage, float angle, bool bTakedown, int elemType, float shockForce, float heavy, int* outRealDamage)
{
	if (getDamage == 0)
		return false;
	*outRealDamage = getDamage;
	hp -= getDamage;
	if (hp > 0)
	{
		gameFunc->PlaySound(L"CS_053_enemy_hurt_small");
	}
	else
	{
		gameFunc->PlaySound(L"CS_070_expl_small");
		//
		SetCS_PeSmokeSmall(shared_from_this(), x, y);
		hp = 0;
		Destroy();
	}
	return true;
}

void SetCS_AmBuyoBuyoBounce(std::shared_ptr<Entity> parent, float x, float y, float vx, float vy)
{
	auto am = std::make_shared<CS_AmBuyoBuyoBounce>(parent);
	am->x = x;
	am->y = y;
	am->vx = vx;
	am->vy = vy;
	parent->gameFunc->SetEntity(parent, am);
}
