#pragma once
#include "global.h"
#include "MyView.h"
#include "MapDrawer.h"
#include "MyCamera.h"
#include "EntityRes.h"
#include "GameInput.h"
#include "GameScript.h"
#include "ScriptCmd.h"
#include "GameMsgbox.h"
#include "GameFade.h"
#include "GameUI.h"
#include "GameTimer.h"
#include "DmgNum.h"
#include "MapSystem.h"
#include "GameMap.h"
#include "GamePxa.h"
#include "GamePid.h"
#include "OrganyaPlayer.h"
#include "StageDrawer.h"
#include "ItemSystem.h"
#include "SlotDrawer.h"
#include "GameFlash.h"
#include "Pathfinding.h"
class MyGame
{
public:
	void Init(MyDX11Renderer* pRenderer, MySDLInput* pInput, JoystickInput* pJoystickInput, MyView* pView, const GameFunc* pGameFunc);//ʼϷ
	void SetMainGame();//ǰϷΪϷӰһЩȫֱ
	void EnableDrawDebug(bool bEnable);
	void SetUIVisiable(bool bVisiable);//ѪUIʾ
	void LoadSetting(const wchar_t* settingName);//
	void LoadSetting(const wchar_t* mapfileName, const wchar_t* mycharName, int xPos, int yPos, int lr = 0, bool hidePlayer = false, bool bLight = true, bool runEvent = false, const wchar_t* eventName = nullptr);
	void LoadMap(const wchar_t* mapfileName);//ֱͼ
	void StartEvent(const wchar_t* eventName, const wchar_t* triggerType);//¼
	virtual void Draw(float deltaTime);
	virtual void Step();
	virtual void Reset();
	void Controll();
	virtual void OnResetScale(int w, int h);
	std::weak_ptr<Entity> GetMyChar_Player1();
	std::weak_ptr<Entity> GetMyChar_Player1_menuKeyboard();
	std::weak_ptr<Entity> GetMyChar_Player2();
	std::weak_ptr<Entity> GetMyChar_Player2_menuKeyboard();
	void SetMyChar_Player1(std::weak_ptr<Entity> e);//1Ŀʵ
	void SetMyChar_Player2(std::weak_ptr<Entity> e);//2Ŀʵ
	bool TitleStageOk();//ȷ˱⻭
	void GetDebugEntityNum(int* outLsNum, int* outMcNum, int* outAmNum, int* outPeNum);
	virtual void SaveGame(std::vector<char>* saveData);
	virtual void LoadGame(const char* loadData);
	void ReloadLanguage();
	void ReloadGameMapScript();//Ʒ
	void SetGlobalEntity(std::shared_ptr<Entity> we, const wchar_t* globalEntityID);//ʵõȫ
	std::weak_ptr<Entity> GetGlobalEntity(const wchar_t* globalEntityID);//ȡȫʵָ
	std::unordered_map<std::wstring, std::weak_ptr<Entity>>* GetGlobalEntityTable();
	int GetPlayerIndex(std::weak_ptr<Entity> e);//ȡǰʵ±
	std::weak_ptr<Entity> GetPlayerDistance(float x, float y);//ȡõ
	std::weak_ptr<Entity> GetPlayerDistanceLR(float x, float y, int lr);//ȡõһ
	std::weak_ptr<Entity> GetPlayerDistanceWithLineTest(float x, float y);//ȡõĿֱ
	std::weak_ptr<Entity> GetPlayerDistanceLRWithLineTest(float x, float y, int lr);//ȡõһĿֱ
	std::weak_ptr<Entity> GetCheckEventPlayer();//ȡһڵ¼
	void SetQuake(int times, int mode);//mode:0С1󶶶
	void SetLocalCamera(std::weak_ptr<Entity> e, float focusTimes);//þֲ
	void UnsetLocalCamera(std::weak_ptr<Entity> e);//ȡõλľ۽
	void EnableItemSystem(bool bEnable);//Ʒϵͳ
	void LockAllPlayerJump();//ֹԾ
	void SaveAllPlayerPosition();//
	void LoadAllPlayerPosition();//
	void NoEnemyMode();
	void KillAllEnemy();//ɱе
	void MoveAllPlayerToMousePos();//ƶҵλ
	bool InBossFight();
	void FullLight();//еͼ1
	void TryControlMousePosEntity();//ԿĿ꣨ǿɲٿصҽɫ
	ScriptCmd* GetCmd();
private:
	//ʼ
	MyDX11Renderer* pRenderer = nullptr;
	MySDLInput* pInput = nullptr;
	JoystickInput* pJoystickInput = nullptr;
	MyView* pView = nullptr;
	GameFunc gameFunc;
	bool enableDrawDebug;
	bool bChildGame = false;
	bool bSetKillAllEnemy = false;
	bool bSetMoveAllPlayerToMousePos = false;
	bool bSetTryControlMousePosEntity = false;
	float game_delteTime = 0;
	bool enablePlayer2AISwitch = true;//2AIл
	//Ϸ
	std::set<std::wstring> flagSet;//Ϸflag
	std::set<std::wstring> skipSet;//skip
	//1
	GameInput gameInput_player1;
	std::weak_ptr<Entity> mychar_player1;//1ڿƵĽɫ
	std::weak_ptr<Entity> mychar_player1_menuKeyboard;//1Ĳ˵ʵ壨Ϸֻ֤˵ü̿ƣ
	//2
	GameInput gameInput_player2;
	std::weak_ptr<Entity> mychar_player2;//2ڿƵĽɫ
	std::weak_ptr<Entity> mychar_player2_menuKeyboard;//2Ĳ˵ʵ壨Ϸֻ֤˵ü̿ƣ
	//һε¼±
	int checkEventPlayerIndex = 0;
	//
	bool(GameInput::* GetKey[20])();
	void(GameInput::* SetKey[20])(bool);
	SDL_Scancode* is_p1k[20];
	SDL_Scancode* is_p2k[20];
	SDL_GameControllerButtonBind* is_p1j[20];
	SDL_GameControllerButtonBind* is_p2j[20];
	//ģ
	GameMap gameMap;
	GamePxa gamePxa;
	GamePid gamePid;
	MyCamera myCamera;
	EntityRes entityRes;
	GameScript gameScript;
	ScriptCmd scriptCmd;
	GameMsgbox gameMsgbox;
	GameFade gameFade;
	GameUI gameUI;
	GameTimer gameTimer;
	DmgNum dmgNum;
	MapSystem mapSystem;
	StageDrawer stageDrawer;
	ItemSystem itemSystem;
	SlotDrawer slotDrawer;
	GameFlash gameFlash;
	std::unique_ptr<MyGame> credit;
	MyView creditView;
	//ҵ¼
	void PlayerCheckEvent();
	void GridPlayerCheckEvent(std::weak_ptr<Entity> player);
	void PlayerWaitStand();
	void DrawDark();
	void Keyboard();
	void Joystick();
	void StepEntitySystem();
	void DeltaTimeEntitySystem(float deltaTime);
	//ȫʵ
	std::unordered_map<std::wstring, std::weak_ptr<Entity>> globalEntityTable;
	std::list<std::shared_ptr<Entity>> globalEntity;
	std::list<std::shared_ptr<Entity>> globalEntity_addList;
	std::list<Entity> positionSaver;//걣
	void StepGlobalEntity(MyMapLayer* pLayer, PxaData* pxaData);
	void DeltaTimeGlobalEntity(MyMapLayer* pLayer, float deltaTime);
	void SwitchPlayerStep();//лɫ
	void SwapPlayer();//12Ľɫ
	//޵ģʽ
	bool bNoEnemyMode = false;
	void ClearEnemy();//ǰеĵ
	//Ԫ
	friend class GameScript;
	friend class ScriptCmd;
	friend class MiniScriptSystem;
	friend class ItemSystem;
};

