#pragma once
#include "global.h"
//֡
struct AniFrame
{
	int id = 0;//pid
	float offx = 0;
	float offy = 0;
};
//
struct AniLayer
{
	std::vector<AniFrame> frameList;
};

//
struct AniPrep
{
	bool loop = false;
	int speed = 0;
	int texture_up = 16;
	int texture_down = 16;
	int texture_left = 16;
	int texture_right = 16;
	std::vector<AniLayer> layerList;
};
//Pidļ
struct PidData
{
	//ͼ
	int pid_tile_w = 16;
	int pid_tile_h = 16;
	bool bInterArea = false;
	std::unordered_map<int, MyRect> pidList;
	std::unordered_map<std::wstring, AniPrep> aniList;
};
//PidļͶȡ
class GamePid
{
public:
	PidData* GetPid(const wchar_t* pidName);
	void ReloadLanguage();//Բ
private:
	std::unordered_map<std::wstring, PidData> loadedPid;//pid
	static void LoadPid(PidData* outPidData, const wchar_t* pidName);
	static void LoadPidXML(PidData* outPidData, const wchar_t* xml);
};

