#pragma once
#include "global.h"
//ǰ
class Entity;
struct MyView;
struct MyMapLayer;
struct MapLayer;
struct EntityLayer;
struct GameFunc;
struct PxaData;
struct EntityLoad;
struct PathCell;
struct PathGrid;
class GameMap;
class GamePxa;
class GamePid;
class Pathfinding;
//
struct GroupByDraw
{
	MyRect src, dst;
	DWORD color;
};

//ʵԼ
class EntityRes
{
public:
	//GameFunc
	static std::unordered_map<MapLayer*, EntityLayer>* GetLoadedEntity(EntityRes* entityRes);
	//EntityRes
	EntityRes() = default;
	virtual ~EntityRes();
	EntityRes(const EntityRes&) = delete;//ֹʵ
	EntityRes& operator=(const EntityRes&) = delete;//ֹʵ
	void Init(MyDX11Renderer* pRenderer, MySDLInput* pInput, MyView* pView, int* pMapW, int* pMapH, GamePid* gamePid, GameFunc* gameFunc,
		std::weak_ptr<Entity>* mychar_ptr_Player1, std::weak_ptr<Entity>* mychar_ptr_Player1_menuKeyboard, std::weak_ptr<Entity>* mychar_ptr_Player2, std::weak_ptr<Entity>* mychar_ptr_Player2_menuKeyboard,
		int* pCheckEventPlayerIndex, std::list<std::shared_ptr<Entity>>* globalEntity);
	void InitFrom(const EntityRes* otherEntityRes);
	void SetView(MyView* pView);
	void Reset();//
	EntityLayer* LoadLayer(MyMapLayer* pLayer);//һʵ
	void StepEntityLayer(MyMapLayer* pLayer);//ִһʵ
	void StepEntityLayerPe(MyMapLayer* pLayer);//ִֻиʵеЧʵ
	void DrawEntityLayer(MyMapLayer* pLayer, bool inTopDraw = false);//һʵ
	void DeltaTimeEntityLayer(MyMapLayer* pLayer, float deltaTime);//ִһʵ
	void DrawAddEntity(std::shared_ptr<Entity>& we, bool inTopDraw = false);
	void DrawShaderEntity(std::shared_ptr<Entity>& we, bool inTopDraw = false);//ɫʵ
	void DrawEntity();//ʵ
	void DrawEntityText(std::weak_ptr<Entity> e, DWORD color, bool inTopDraw = false);//ʵı
	void DrawEntityCbRectLayer(MyMapLayer* pLayer);//ʵײ
	void DrawEntityEventNameLayer(MyMapLayer* pLayer);//ʵ¼
	void StepList(std::list<std::shared_ptr<Entity>>* entityList);
	void DeleteStepList(std::list<std::shared_ptr<Entity>>* entityList);//ֻɾİ汾
	void MoveEntity(std::weak_ptr<Entity> e, int x, int y);
	void MoveEntity(std::weak_ptr<Entity> e, const wchar_t* eventName);
	std::weak_ptr<Entity> SetNpc(MyMapLayer* pLayer, const wchar_t* npcName, float xPos, float yPos, int stateID, int lr);
	std::weak_ptr<Entity> SetNpc(const wchar_t* npcName, int x, int y, int lr, const wchar_t* layerName, const wchar_t* eventName);
	std::weak_ptr<Entity> SetNpc(const wchar_t* npcName, int x, int y, int lr, const wchar_t* layerName, const wchar_t* eventName, const wchar_t* triggerName);
	int DeleteNpc(const wchar_t* eventName);
	void DeleteNpc(std::weak_ptr<Entity> e);
	std::weak_ptr<Entity> GetMyChar_Player1();
	std::weak_ptr<Entity> GetMyChar_Player1_menuKeyboard();
	std::weak_ptr<Entity> GetMyChar_Player2();
	std::weak_ptr<Entity> GetMyChar_Player2_menuKeyboard();
	std::weak_ptr<Entity> GetEntity(const wchar_t* eventName);
	void ANP(const wchar_t* eventName, int stateID, int lr);
	void ANP(const wchar_t* eventName, int stateID);
	void ANP(const wchar_t* eventName, const wchar_t* stateName, int lr);
	void ANP(const wchar_t* eventName, const wchar_t* stateName);
	void ATP(const wchar_t* npcName, const wchar_t* stateName);
	void ChangeNpc(const wchar_t* eventName, const wchar_t* npcName, int stateID, int lr);
	void ChangeNpc(const wchar_t* eventName, const wchar_t* npcName, int stateID);
	void MoveNpc(const wchar_t* eventName, int x, int y, int lr);
	void MoveNpc(const wchar_t* eventName, const wchar_t* dstEventName);
	int KillNpc(const wchar_t* npcName, int damage);
	void SetNpcTopDraw(const wchar_t* eventName, bool enable);
	void ResetEnemy(std::vector<std::wstring>& nameArr);//λùؿе
	void OnResetScale();
	void EntityAniStep(std::shared_ptr<Entity>& we);
	void AmStep(EntityLayer* entityLayer);//ҩײ
	bool AmTarget(std::shared_ptr<Entity>& am, std::shared_ptr<Entity>& target);
	static void CollisionEntity(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w);
	static void CollisionEntityBig(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w);
	static void CollisionEntitySmall(std::weak_ptr<Entity> e, std::vector<LONG>* pxmArr, std::vector<int>* pxaArr, std::map<LONG, LONG>* updatedPxmArr, int pxmArr_w, int pxaArr_w);
	void CollisionMovingPlatform(std::weak_ptr<Entity> e);
	void SetCollisionEntityLayer(MyMapLayer* pLayer, PxaData* pxaData);
	void GetDebugEntityNum(int* outLsNum, int* outAmNum, int* outPeNum);
	void EntitySaveData();//ʵдݵ
	void EntityLoadData();//ʵȡݵ
	void ReloadLanguage();//ʵReloadLanguageϢ
	ID3D11VertexShader* GetVertexShader(const wchar_t* vsName);//ȡɫ
	ID3D11PixelShader* GetPixelShader(const wchar_t* psName);//ȡɫ
	static void GetDisplayInfo(EntityRes* pEntityRes, float* outWindow_w, float* outWindow_h, float* outScale, float* outOffX, float* outOffY);
	static void GetMousePos(EntityRes* pEntityRes, float* pX, float* pY);
	static bool InScreen(EntityRes* pEntityRes, float x, float y);//ǷĻʾΧ
	static void GridTouch(EntityRes* entityRes, std::weak_ptr<Entity> src, EntityLayer* targetLayer);//ȡʵӴʵ
	void ClearLightList();//һεķʵ¼
	void DrawLightEntity(MyMapLayer* pLayer);//Ʒʵ
	void MarkLightEntity(MyMapLayer* pLayer);//ǵǰеĵƹʵ
	void SetELTable(const wchar_t* eventName, EntityLoad* pEl);
	void DelELTable(const wchar_t* eventName);
	void ClrELTable();
	static PathCell* GetPath(std::weak_ptr<Entity> e, float dstX, float dstY, float srcX, float srcY);
	static bool LineTest(std::weak_ptr<Entity> e, float srcX, float srcY, float dstX, float dstY);
	void DrawPath();//Ѱ·ϵͳ
	void UpdatePathFinder();
	GameFunc* GetGameFunc();
	void DrawEntityGlobalIDName(std::weak_ptr<Entity> e);
	void DrawQuadTree(MyMapLayer* entityLayer);
	void GridRemoveEntity(std::shared_ptr<Entity>& we);
	void GridSetEntity(std::shared_ptr<Entity>& we);
	void SetStarBlockBreakEffect(std::wstring smokeNpcName, int setNum, std::wstring breakSoundName);
private:
	MyDX11Renderer* pRenderer = nullptr;
	MySDLInput* pInput = nullptr;
	MyView* pView = nullptr;
	int* pMapW = nullptr;
	int* pMapH = nullptr;
	GamePid* gamePid = nullptr;
	GameFunc* gameFunc = nullptr;
	std::weak_ptr<Entity>* mychar_ptr_Player1 = nullptr;
	std::weak_ptr<Entity>* mychar_ptr_Player1_menuKeyboard = nullptr;
	std::weak_ptr<Entity>* mychar_ptr_Player2 = nullptr;
	std::weak_ptr<Entity>* mychar_ptr_Player2_menuKeyboard = nullptr;
	int* pCheckEventPlayerIndex = nullptr;
	std::list<std::shared_ptr<Entity>>* globalEntity = nullptr;
	std::unordered_map<MyMapLayer*, EntityLayer> loadedEntity;
	std::unordered_map<wchar_t, MyFontData> fontMap;
	TTF_Font* myfont14 = nullptr;
	std::unordered_map<wchar_t, MyFontData> fontMap_myfont14;
	std::unordered_map<std::wstring, std::vector<GroupByDraw>> groupByDraw;
	//
	std::vector<MyDX11PenVertex> lineList;
	std::vector<MyDX11PenVertex> fillList;
	EntityLayer* GetEntityLayer(MyMapLayer* pLayer);
	std::weak_ptr<Entity> LoadEntity(const EntityLoad* el, MapLayer* mapLayer, EntityLayer* entityLayer);
	void DrawAddEntityCbRect(std::weak_ptr<Entity> e, DWORD c);
	void DrawEntityEventName(std::weak_ptr<Entity> e);
	//ɫ
	std::unordered_map<std::wstring, ID3D11VertexShader*> loadedVertexShader;//Ķɫ
	std::unordered_map<std::wstring, ID3D11PixelShader*> loadedPixelShader;//ɫ
	//ʵԤȾ
	ExTextureBuffer preTexture;
	ID3D11Texture2D* GetPreTexture(UINT w, UINT h);
	//ʵ
	std::vector<std::weak_ptr<Entity>> lightList;//ʵ
	//ײŻ
	void GridItemTarget(std::shared_ptr<Entity>& we);
	bool GridAmTarget(std::shared_ptr<Entity>& we);
	//ʵԤ
	std::unordered_map<std::wstring, EntityLoad> elTable;
	//Ѱ·ϵͳ
	std::unordered_map<EntityLayer*, Pathfinding> pfSys;
	PathGrid* lastPathGrid = nullptr;
	//ש
	std::wstring starblock_smokeNpcName;
	int starblock_setnum = 4;
	std::wstring starblock_breakSoundName;
};
