function MergePNGsToAseprite(pngFiles, outputFile)
    -- 从第一个PNG获取尺寸
    local firstImg = Image{ fromFile=pngFiles[1] }
    local width, height = firstImg.width, firstImg.height
    
    -- 创建新精灵
    local sprite = Sprite(width, height)
    sprite.filename = outputFile
    
    -- 添加每个PNG作为新图层
    for i, pngPath in ipairs(pngFiles) do
        local layer = sprite:newLayer()
        layer.name = getPureFilename(pngPath)
        sprite:newCel(layer, 1)
        local cel = layer:cel(1)
        local img = Image{ fromFile=pngPath }
        cel.image = img
    end
    
    -- 保存文件
    sprite:saveAs(outputFile)
    app.exit()  -- 执行完成后退出
end

function getPureFilename(path)
    -- 处理目录分隔符（Windows支持/和\两种）
    local normalizedPath = path:gsub("/", "\\")
    
    -- 从路径中提取文件名部分（含扩展名）
    local filenameWithExt = normalizedPath:match("[^\\]+$") or normalizedPath
    
    -- 剔除文件扩展名
    local pureFilename = filenameWithExt:match("(.+)%..+$") or filenameWithExt
    
    -- 如果文件名以点开头且没有其他扩展名（如".gitignore"）
    if pureFilename == "" and filenameWithExt:match("^%..+") then
        pureFilename = filenameWithExt
    end
    
    return pureFilename
end

-- 从命令行参数获取文件列表
local pngNum = tonumber(app.params["argNum"])
local pngFiles = {}
for i=0,pngNum - 1,1 do
    local keyName = "png"..i
    table.insert(pngFiles, app.params[keyName])
end

local outputFile = app.params["output"]

MergePNGsToAseprite(pngFiles, outputFile)