#pragma once
#include "global.h"
#include "MyStructDef.h"
#include "CMyListBox.h"
#include "CPxaEditorDraw.h"
#include "CPxaEditorBrush.h"
#define CPXAEDITOR_MENUINDEX_FILE 0
#define CPXAEDITOR_MENUINDEX_EDIT 1
#define CPXAEDITOR_MENUINDEX_OPTION 2
#define CPXAEDITOR_MENUINDEX_WINDOW 3
//Pxa༭
class CPxaEditor : public CDialog
{
	DECLARE_DYNAMIC(CPxaEditor)
	DECLARE_MESSAGE_MAP()
public:
	CPxaEditor(CWnd* pParent = nullptr);   // ׼캯
	virtual ~CPxaEditor();
	// Ի
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_CPXAEDITOR };
#endif
	void* pMainEditor = nullptr;
	bool showGrid = false;//ʾ
	bool showBk = false;//ʾ͸
	//ͼ
	float* pPxa_tile_w;
	float* pPxa_tile_h;
	bool bInterArea = false;
	void Draw();//
	void Load(CString filename);//ļ
	static void StaticLoad(CString pxaName, CPXAEDITOR_DATATYPE_PXA* pxaList, int* outTileW, int* outTileH, bool* outInterArea = nullptr);
	void Save();//
	bool Close();
	CPXAEDITOR_DATATYPE_PXA* GetStep();
	void UpdateMenuState();//²˵״̬
	void UpdateWindowTitle();//´ڱ
	bool CheckSaved();
	bool IsLoaded();
	void ResetContext();
	MyUndoRedo* GetMyUndoRedo();
	void XMLLoad(CString xml);
	static void StaticXMLLoad(CString xml, CPXAEDITOR_DATATYPE_PXA* pxaList, int* outTileW, int* outTileH, bool* outInterArea);
	CString XMLSaved();
	int GetSelectPxaValue();
	MyView* GetBrushView();
	////////////////////ȼ//////////////////
	HACCEL hAccel = nullptr;//ȼ
	BOOL PreTranslateMessage(MSG* pMsg) override;
protected:
	void DoDataExchange(CDataExchange* pDX) override;
	BOOL OnInitDialog() override;
	void OnCancel() override;
	void OnEnterKey();//պ ֹس˳
public:
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMoving(UINT fwSide, LPRECT pRect);
	afx_msg void OnEditPxa();
	afx_msg void OnEditPng();
	afx_msg void OnOpenFolder();
	afx_msg void OnUpdateList();
	afx_msg void OnOpenFile();
	afx_msg void OnSaveFile();
	afx_msg void OnCloseFile();
	afx_msg void OnUndo();
	afx_msg void OnRedo();
	afx_msg void OnCopy();
	afx_msg void OnPaste();
	afx_msg void OnCut();
	afx_msg void OnShowBk();
	afx_msg void OnShowGrid();
	afx_msg void OnGridSetting();
	afx_msg void OnBrushWnd();
	afx_msg void OnResetWndPos();
	afx_msg void OnLbnDblclkListPnglist();
private:
	//ؼ
	CStatic* static_pxaList;
	CMyListBox listbox_pxaList;
	CStatic* static_pxaEditor;
	//Ӵ
	CPxaEditorDraw pDrawWnd;
	CPxaEditorBrush pBrushWnd;
	//
	CString pngfile;
	CString pxafile;
	int pxa_tile_w_saved = 16;
	int pxa_tile_h_saved = 16;
	bool bInterArea_saved = false;
	//
	MyUndoRedo undoRedo;
	CPXAEDITOR_DATATYPE_PXA saved;

	//ճ
	int pxaCopy;
	void StepCopyToSaved();
};

