#include "CPidEditorBrushGrid.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(CPidEditorBrushGrid, CDialog)

BEGIN_MESSAGE_MAP(CPidEditorBrushGrid, CDialog)
	ON_BN_CLICKED(IDOK, &CPidEditorBrushGrid::OnBnClickedOk)
END_MESSAGE_MAP()

CPidEditorBrushGrid::CPidEditorBrushGrid(CWnd* pParent)
	: CDialog(IDD_CPIDEDITOR_BRUSH_GRID, pParent)
{
}

CPidEditorBrushGrid::~CPidEditorBrushGrid()
{
}

void CPidEditorBrushGrid::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_BRUSH_W, edit_brush_w);
	DDX_Control(pDX, IDC_EDIT_BRUSH_H, edit_brush_h);
}

BOOL CPidEditorBrushGrid::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetDlgItemInt(IDC_EDIT_BRUSH_W, outBrushW);
	SetDlgItemInt(IDC_EDIT_BRUSH_H, outBrushH);
	return 0;
}

void CPidEditorBrushGrid::OnBnClickedOk()
{
	
	int brush_w = GetDlgItemInt(IDC_EDIT_BRUSH_W);
	if (brush_w < 1)
	{
		MessageBox(L"ˢߴȲС1", L"дЧ");
		return;
	}

	int brush_h = GetDlgItemInt(IDC_EDIT_BRUSH_H);
	if (brush_h < 1)
	{
		MessageBox(L"ˢߴ߶ȲС1", L"дЧ");
		return;
	}
	outBrushW = brush_w;
	outBrushH = brush_h;
	CDialog::OnOK();
}
