#include "COSLabel.h"
#include "resource.h"

IMPLEMENT_DYNAMIC(COSLabel, CDialog)

BEGIN_MESSAGE_MAP(COSLabel, CDialog)
	ON_BN_CLICKED(IDOK, &COSLabel::OnBnClickedOk)
END_MESSAGE_MAP()

COSLabel::COSLabel(CWnd* pParent)
	: CDialog(IDD_COSLABEL, pParent)
{
}

COSLabel::~COSLabel()
{
}

void COSLabel::SetWindowTitleAndLabel(CString title, CString label)
{
	this->title = title;
	this->label = label;
}

void COSLabel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_OSLABEL, edit_label);
	static_label = (CStatic*)GetDlgItem(IDC_STATIC_OSLABEL);
}

BOOL COSLabel::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetWindowTextW(title);
	static_label->SetWindowTextW(label);
	if (load)
		edit_label.SetWindowTextW(outLabel.GetString());
	return 0;
}


void COSLabel::OnBnClickedOk()
{
	
	//ıǷд
	CString text;
	edit_label.GetWindowTextW(text);
	if (text.GetLength() == 0)
	{
		MessageBox(L"ݲΪ", L"δύ", MB_ICONINFORMATION);
		return;
	}
	//
	outLabel = text;
	CDialog::OnOK();
}
