#include "CAniOp.h"
#include "resource.h"
#include "CAniEditorHideTable.h"
IMPLEMENT_DYNAMIC(CAniOp, CDialog)

BEGIN_MESSAGE_MAP(CAniOp, CDialog)
	ON_BN_CLICKED(IDOK, &CAniOp::OnBnClickedOk)
	ON_BN_CLICKED(IDC_RADIO_ALL_LAYER, &CAniOp::OnBnClickedRadioAllLayer)
	ON_BN_CLICKED(IDC_RADIO_IGN_LAYER, &CAniOp::OnBnClickedRadioIgnLayer)
	ON_BN_CLICKED(IDC_RADIO_DST_LAYER, &CAniOp::OnBnClickedRadioDstLayer)
	ON_BN_CLICKED(IDC_RADIO_ALL_FRAME, &CAniOp::OnBnClickedRadioAllFrame)
	ON_BN_CLICKED(IDC_RADIO_IGN_FRAME, &CAniOp::OnBnClickedRadioIgnFrame)
	ON_BN_CLICKED(IDC_RADIO_DST_FRAME, &CAniOp::OnBnClickedRadioDstFrame)
	ON_BN_CLICKED(IDC_BUTTON_L2R, &CAniOp::OnBnClickedButtonL2r)
	ON_BN_CLICKED(IDC_BUTTON_R2L, &CAniOp::OnBnClickedButtonR2l)
END_MESSAGE_MAP()

CAniOp::CAniOp(CWnd* pParent)
	: CDialog(IDD_CANIEDITOR_ANIOP, pParent)
{
}

CAniOp::~CAniOp()
{
}

void CAniOp::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_RADIO_ALL_LAYER, radio_allLayer);
	DDX_Control(pDX, IDC_RADIO_IGN_LAYER, radio_ignLayer);
	DDX_Control(pDX, IDC_RADIO_DST_LAYER, radio_dstLayer);
	DDX_Control(pDX, IDC_EDIT_NUM_LAYER, edit_numLayer);

	DDX_Control(pDX, IDC_RADIO_ALL_FRAME, radio_allFrame);
	DDX_Control(pDX, IDC_RADIO_IGN_FRAME, radio_ignFrame);
	DDX_Control(pDX, IDC_RADIO_DST_FRAME, radio_dstFrame);
	DDX_Control(pDX, IDC_EDIT_NUM_FRAME, edit_numFrame);

	DDX_Control(pDX, IDC_RADIO_PID_PLUS, radio_pid_op_plus);
	DDX_Control(pDX, IDC_RADIO_PID_DST, radio_pid_op_dst);
	DDX_Control(pDX, IDC_EDIT_PID_OP_NUM, edit_pid_op_num);

	DDX_Control(pDX, IDC_RADIO_OFFSET_X_PLUS, radio_offset_x_op_plus);
	DDX_Control(pDX, IDC_RADIO_OFFSET_X_MUL, radio_offset_x_op_mul);
	DDX_Control(pDX, IDC_RADIO_OFFSET_X_DST, radio_offset_x_op_dst);
	DDX_Control(pDX, IDC_EDIT_OFFSET_X_OP_NUM, edit_offset_x_op_num);

	DDX_Control(pDX, IDC_RADIO_OFFSET_Y_PLUS, radio_offset_y_op_plus);
	DDX_Control(pDX, IDC_RADIO_OFFSET_Y_MUL, radio_offset_y_op_mul);
	DDX_Control(pDX, IDC_RADIO_OFFSET_Y_DST, radio_offset_y_op_dst);
	DDX_Control(pDX, IDC_EDIT_OFFSET_Y_OP_NUM, edit_offset_y_op_num);

	DDX_Control(pDX, IDC_BUTTON_L2R, button_l2r);
	DDX_Control(pDX, IDC_BUTTON_R2L, button_r2l);
}

BOOL CAniOp::OnInitDialog()
{
	CDialog::OnInitDialog();
	CString title;
	title.Format(L"任%s", inAniName.GetString());
	SetWindowTextW(title);
	edit_numLayer.EnableWindow(false);
	//ؼʼֵ
	switch (outArg.layerTargetMode)
	{
	case 0:
		radio_allLayer.SetCheck(true);
		break;
	case 1:
		radio_ignLayer.SetCheck(true);
		edit_numLayer.EnableWindow(true);
		break;
	case 2:
		radio_dstLayer.SetCheck(true);
		edit_numLayer.EnableWindow(true);
		break;
	}
	edit_numLayer.SetWindowTextW(outArg.layerList.GetString());

	edit_numFrame.EnableWindow(false);
	switch (outArg.frameTargetMode)
	{
	case 0:
		radio_allFrame.SetCheck(true);
		break;
	case 1:
		radio_ignFrame.SetCheck(true);
		edit_numFrame.EnableWindow(true);
		break;
	case 2:
		radio_dstFrame.SetCheck(true);
		edit_numFrame.EnableWindow(true);
		break;
	}
	edit_numFrame.SetWindowTextW(outArg.frameList.GetString());

	switch (outArg.pidOpMode)
	{
	case 0:
		radio_pid_op_plus.SetCheck(true);
		break;
	case 1:
		radio_pid_op_dst.SetCheck(true);
		break;
	}
	CString pidNum;
	pidNum.Format(L"%d", outArg.pidOpNum);
	edit_pid_op_num.SetWindowTextW(pidNum.GetString());
	switch (outArg.offsetXOpMode)
	{
	case 0:
		radio_offset_x_op_plus.SetCheck(true);
		break;
	case 1:
		radio_offset_x_op_mul.SetCheck(true);
		break;
	case 2:
		radio_offset_x_op_dst.SetCheck(true);
		break;
	}
	CString offsetXNum;
	offsetXNum.Format(L"%f", outArg.offsetXOpNum);
	edit_offset_x_op_num.SetWindowTextW(offsetXNum.GetString());
	switch (outArg.offsetYOpMode)
	{
	case 0:
		radio_offset_y_op_plus.SetCheck(true);
		break;
	case 1:
		radio_offset_y_op_mul.SetCheck(true);
		break;
	case 2:
		radio_offset_y_op_dst.SetCheck(true);
		break;
	}
	CString offsetYNum;
	offsetYNum.Format(L"%f", outArg.offsetYOpNum);
	edit_offset_y_op_num.SetWindowTextW(offsetYNum.GetString());
	return 0;
}


void CAniOp::OnBnClickedOk()
{
	std::vector<int> temp;
	//ѡ
	if (radio_ignLayer.GetCheck() || radio_dstLayer.GetCheck())
	{
		CString str;
		edit_numLayer.GetWindowTextW(str);
		//edit_numLayerǷɹ
		if (!CAniEditorHideTable::ParseInts(str.GetString(), temp))
		{
			MessageBoxW(L"ͼַʧܣ\nöŸ", L"ıʧ");
			return;
		}
	}
	if (radio_allLayer.GetCheck())
		outArg.layerTargetMode = 0;
	else if(radio_ignLayer.GetCheck())
		outArg.layerTargetMode = 1;
	else if (radio_dstLayer.GetCheck())
		outArg.layerTargetMode = 2;
	edit_numLayer.GetWindowTextW(outArg.layerList);


	if (radio_ignFrame.GetCheck() || radio_dstFrame.GetCheck())
	{
		CString str;
		edit_numFrame.GetWindowTextW(str);
		//edit_numLayerǷɹ
		if (!CAniEditorHideTable::ParseInts(str.GetString(), temp))
		{
			MessageBoxW(L"ͼַʧܣ\nöŸ", L"ıʧ");
			return;
		}
	}
	if (radio_allFrame.GetCheck())
		outArg.frameTargetMode = 0;
	else if (radio_ignFrame.GetCheck())
		outArg.frameTargetMode = 1;
	else if (radio_dstFrame.GetCheck())
		outArg.frameTargetMode = 2;
	edit_numFrame.GetWindowTextW(outArg.frameList);


	CString pidOpNum;
	edit_pid_op_num.GetWindowTextW(pidOpNum);
	if (pidOpNum.GetLength() == 0)
	{
		MessageBoxW(L"pidֵΪ", L"дЧ");
		return;
	}
	if (swscanf_s(pidOpNum.GetString(), L"%d", &outArg.pidOpNum) == -1)
	{
		MessageBoxW(L"pidֵʧ", L"дЧ");
		return;
	}
	if (radio_pid_op_plus.GetCheck())
		outArg.pidOpMode = 0;
	else if(radio_pid_op_dst.GetCheck())
		outArg.pidOpMode = 1;

	CString offsetXOpNum;
	edit_offset_x_op_num.GetWindowTextW(offsetXOpNum);
	if (offsetXOpNum.GetLength() == 0)
	{
		MessageBoxW(L"offset_xֵΪ", L"дЧ");
		return;
	}
	if (swscanf_s(offsetXOpNum.GetString(), L"%f", &outArg.offsetXOpNum) == -1)
	{
		MessageBoxW(L"offset_xֵʧ", L"дЧ");
		return;
	}
	if (radio_offset_x_op_plus.GetCheck())
		outArg.offsetXOpMode = 0;
	else if (radio_offset_x_op_mul.GetCheck())
		outArg.offsetXOpMode = 1;
	else if (radio_offset_x_op_dst.GetCheck())
		outArg.offsetXOpMode = 2;

	CString offsetYOpNum;
	edit_offset_y_op_num.GetWindowTextW(offsetYOpNum);
	if (offsetYOpNum.GetLength() == 0)
	{
		MessageBoxW(L"offset_xֵΪ", L"дЧ");
		return;
	}
	if (swscanf_s(offsetYOpNum.GetString(), L"%f", &outArg.offsetYOpNum) == -1)
	{
		MessageBoxW(L"offset_yֵʧ", L"дЧ");
		return;
	}
	if (radio_offset_y_op_plus.GetCheck())
		outArg.offsetYOpMode = 0;
	else if (radio_offset_y_op_mul.GetCheck())
		outArg.offsetYOpMode = 1;
	else if (radio_offset_y_op_dst.GetCheck())
		outArg.offsetYOpMode = 2;
	CDialog::OnOK();
}


void CAniOp::OnBnClickedRadioAllLayer()
{
	edit_numLayer.EnableWindow(false);
}


void CAniOp::OnBnClickedRadioIgnLayer()
{
	edit_numLayer.EnableWindow(true);
}


void CAniOp::OnBnClickedRadioDstLayer()
{
	edit_numLayer.EnableWindow(true);
}


void CAniOp::OnBnClickedRadioAllFrame()
{
	edit_numFrame.EnableWindow(false);
}


void CAniOp::OnBnClickedRadioIgnFrame()
{
	edit_numFrame.EnableWindow(true);
}


void CAniOp::OnBnClickedRadioDstFrame()
{
	edit_numFrame.EnableWindow(true);
}


void CAniOp::OnBnClickedButtonL2r()
{
	CString strLineShow;
	strLineShow.Format(L"%d", inLineShow);

	radio_allLayer.SetCheck(true);
	radio_ignLayer.SetCheck(false);
	radio_dstLayer.SetCheck(false);

	radio_allFrame.SetCheck(true);
	radio_ignFrame.SetCheck(false);
	radio_dstFrame.SetCheck(false);

	radio_pid_op_plus.SetCheck(true);
	radio_pid_op_dst.SetCheck(false);
	edit_pid_op_num.SetWindowTextW(strLineShow.GetString());

	radio_offset_x_op_plus.SetCheck(false);
	radio_offset_x_op_mul.SetCheck(true);
	radio_offset_x_op_dst.SetCheck(false);
	edit_offset_x_op_num.SetWindowTextW(L"-1");

	radio_offset_y_op_plus.SetCheck(true);
	radio_offset_y_op_mul.SetCheck(false);
	radio_offset_y_op_dst.SetCheck(false);
	edit_offset_y_op_num.SetWindowTextW(L"0");
}


void CAniOp::OnBnClickedButtonR2l()
{
	CString strLineShow;
	strLineShow.Format(L"%d", -inLineShow);

	radio_allLayer.SetCheck(true);
	radio_ignLayer.SetCheck(false);
	radio_dstLayer.SetCheck(false);

	radio_allFrame.SetCheck(true);
	radio_ignFrame.SetCheck(false);
	radio_dstFrame.SetCheck(false);

	radio_pid_op_plus.SetCheck(true);
	radio_pid_op_dst.SetCheck(false);
	edit_pid_op_num.SetWindowTextW(strLineShow.GetString());

	radio_offset_x_op_plus.SetCheck(false);
	radio_offset_x_op_mul.SetCheck(true);
	radio_offset_x_op_dst.SetCheck(false);
	edit_offset_x_op_num.SetWindowTextW(L"-1");

	radio_offset_y_op_plus.SetCheck(true);
	radio_offset_y_op_mul.SetCheck(false);
	radio_offset_y_op_dst.SetCheck(false);
	edit_offset_y_op_num.SetWindowTextW(L"0");
}
