#pragma once
#include "global.h"
#include "CMyTreeCtrl.h"
#include "MyStructDef.h"
#include "CAniEditorDraw.h"
#include "CAniEditorTimeLine.h"
#include "CMyPicButton.h"
#define CANIEDITOR_MENUINDEX_OPTION 0
#define CANIEDITOR_MENUINDEX_EDIT 1
class CAniEditor : public CDialog
{
	DECLARE_DYNAMIC(CAniEditor)
	DECLARE_MESSAGE_MAP()
public:
	CAniEditor(CWnd* pParent = nullptr);   // ׼캯
	virtual ~CAniEditor();
	// Ի
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_CANIEDITOR };
#endif
	void* pParentEditor = nullptr;
	int* pPid_tile_w = nullptr;
	int* pPid_tile_h = nullptr;
	void Load(CString filename);//ͼpngļ
	void ResetContext();
	CString XMLSaved();
	void XMLLoad(CString xml);
	bool CheckSaved();
	void StepCopyToSaved();
	void UpdateMenuState();//²˵״̬
	void UpdateWindowTitle();//´ڱ
	void Draw();
	void SetAniID(int id);//öid
	void SetAniFrame(const MyAniFrame* frame);//öframe
	void GetAniFrame(std::list<MyAniFrame>* frameList);//ȡƶframe
	void GetSelectAniFrame(std::vector<MyAniFrame*>* frameList);//ȡƶframe
	void GetSelectAniInfo(MyAniSet** as);
	MyUndoRedo* GetMyUndoRedo();
	CANIEDITOR_DATATYPE_ANI* GetStep();
	void AniIDSetRect(int id, MyRect* rc);
	bool IsLoaded();
	std::set<int>* GetHideTable();
	int GetSelectedLayerIndex();
	std::unordered_map<std::wstring, MyAniSet>* GetAniList();
	////////////////////ȼ//////////////////
	HACCEL hAccel = nullptr;//ȼ
	BOOL PreTranslateMessage(MSG* pMsg) override;
protected:
	void DoDataExchange(CDataExchange* pDX) override;
	BOOL OnInitDialog() override;
	void OnCancel() override;
	void OnEnterKey();//պ ֹس˳
public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnAddAni();
	afx_msg void OnPrepAni();
	afx_msg void OnAniop();
	afx_msg void OnCopy();
	afx_msg void OnPaste();
	afx_msg void OnCut();
	afx_msg void OnDeleteAni();
	afx_msg void OnRedo();
	afx_msg void OnSaveFile();
	afx_msg void OnUndo();
	afx_msg void OnBkSetting();
	afx_msg void OnTvnSelchangedTreeAnilist(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg LRESULT OnMyPicButtonLButtonUp(WPARAM wParam, LPARAM lParam);
	afx_msg void OnNextframe();
	afx_msg void OnPrevframe();
	afx_msg void OnOpLayer();
	afx_msg void OnHideTable();
	afx_msg void OnChangeId();
private:
	CString pngfile;
	//ؼ
	CStatic* static_aniList;
	CMyTreeCtrl tree_aniList;
	CButton button_edit;
	CStatic* static_playView;
	CStatic* static_timeLine;
	//Ӵ
	CAniEditorDraw pDrawWnd;
	CAniEditorTimeLine pTimeLineWnd;
	CMyPicButton btn_play, btn_pause, btn_stop, btn_refresh;
	//Ա
	std::unordered_map<std::wstring, MyAniSet> anisetList;
	std::unordered_map<std::wstring, MyAniSet> saved;
	CString posCopyXML;//
	MyAniFrame copyFrame;
	UINT_PTR timeid;//ʱ
	bool playing = false;//ǷڲŶ
	int timeCell = 0;
	HTREEITEM lastSelectItem = NULL;
	//ʾر
	CString hideTable;
	CString hideTable_saved;
	std::set<int> hideIDTable;
};

