#include "PeLifeRecoverLine.h"

PeLifeRecoverLine::PeLifeRecoverLine(float dx, float dy)
{
	type = 3;
	allAlpha = 0.5f;
	this->dx = dx;
	this->dy = dy;
	//ʱ
	action_timecounter = action_timecounter_max = 60;
	//ٶ
	vy = -200 / ts;
	//߳
	lineLength = 0;
	lineLength_max = (float)Random(4, 16);
	drawBeforeOtherEntity = true;
}

void PeLifeRecoverLine::Step()
{
	lineList_set_last.swap(lineList_set);
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
			Destroy();
	}
	if (lineLength < lineLength_max)
	{
		lineLength += abs(vy);
		if (lineLength > lineLength_max)
			lineLength = lineLength_max;
	}
	BYTE a = (BYTE)(allAlpha * 0xff * action_timecounter / action_timecounter_max);
	DWORD c = RGBA(0xff, 0xff, 0xff, a);
	AddLine(lineList_set, 0, dx, dy, c, dx, dy + lineLength, c);
	//ִ˶
	Entity::Step();
}

void PeLifeRecoverLine::DeltaTime(float deltaTime)
{
	//λ
	if (lineList.size() < lineList_set_last.size())
		lineList.resize(lineList_set_last.size());
	for (int i = 0; i < lineList_set_last.size(); i++)
	{
		auto& dst = lineList[i];
		auto& src_last = lineList_set_last[i];
		auto& src = lineList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	Entity::DeltaTime(deltaTime);
}
