#include "EntityStateGoldBuff.h"
const int ES_STATENAME_GOLDBUFF = GetNextEntityStateID();
EntityStateGoldBuff::EntityStateGoldBuff()
{
	enable = true;
	stateID = ES_STATENAME_GOLDBUFF;
}

void EntityStateGoldBuff::State()
{
	auto we = e.lock();
	if (!we)
		return;
	if (goldbuff_alpha_counter > 0)
	{
		we->shader.usingShader = true;
		we->shader.vs = we->shader.ps = L"goldbuff";
		//һalpha͸
		if (we->shader.args.size() < 1)
			we->shader.args.resize(1);
		we->shader.args[0] = goldbuff_alpha_counter / goldbuff_alpha_counter_max;
		goldbuff_alpha_counter--;
	}
	else
	{
		we->shader.usingShader = false;
	}
}

bool EntityStateGoldBuff::Hurt(std::weak_ptr<Entity> src, int* pGetDamage, float* pAngle, bool* pTakedown, int* pElemType, float* pShockForce, float* pHeavy, int* outRealDamage, bool* outRetVal)
{
	auto we = e.lock();
	if (!we)
		return false;
	//Ч
	if (goldbuff_alpha_counter > 0)
	{
		auto& getDamage = *pGetDamage;
		auto& angle = *pAngle;
		auto& takedown = *pTakedown;
		auto& elemType = *pElemType;
		auto& shockForce = *pShockForce;
		auto& heavy = *pHeavy;
		*outRealDamage = (int)(getDamage * 1.5f);
		we->hp -= (int)*outRealDamage;
		if (we->hp < 0)
			we->hp = 0;
		//ʾ˺ֵ
		if (we->gameFunc->dmgNum)
			we->gameFunc->SetDmgNum(we->gameFunc->dmgNum, (int)*outRealDamage, we->x, we->y - 16, 1, we);
		return true;//ֱӷ
	}
	return false;
}

void EntityStateGoldBuff::ResetCounter()
{
	goldbuff_alpha_counter = goldbuff_alpha_counter_max;
}
