#include "PePixelCrack.h"

PePixelCrack::PePixelCrack()
{
	type = 3;
	//ײ
	cbRect.enableCbRect = true;
	cbRect.enableSoild = true;
	action_timecounter = action_timecounter_max = 16;
	gravity = 0x48 / ts / 2;
	vx = Random(-3, 3) / 4.0f;
	vy = Random(-5, -1) / 4.0f;
	r = g = b = 0xff;
}

void PePixelCrack::Step()
{
	fillList_set_last.swap(fillList_set);
	BYTE alpha = min(0xff, 0xff * action_timecounter * 2 / action_timecounter_max);
	DWORD c = RGBA(r, g, b, alpha);
	AddFillRect(fillList_set, 0, 0, 0, 1, 1, c, c, c, c);
	vy += gravity;
	//ִ˶
	Entity::Step();
	//һײ
	Entity::ClearCollisionResult();
	//ִײ
	Entity::Collision();
	if (action_timecounter > 0)
	{
		action_timecounter--;
		if (action_timecounter == 0)
			Destroy();
	}
}

void PePixelCrack::DeltaTime(float deltaTime)
{
	//λ
	if (fillList.size() < fillList_set_last.size())
		fillList.resize(fillList_set_last.size());
	for (int i = 0; i < fillList_set_last.size(); i++)
	{
		auto& dst = fillList[i];
		auto& src_last = fillList_set_last[i];
		auto& src = fillList_set[i];
		dst.x = lerp(src_last.x, src.x, deltaTime);
		dst.y = lerp(src_last.y, src.y, deltaTime);
		dst.c = src.c;
	}
	Entity::DeltaTime(deltaTime);
}

void PePixelCrack::SetColor(UINT8 r, UINT8 g, UINT8 b)
{
	this->r = r;
	this->g = g;
	this->b = b;
}

std::shared_ptr<Entity> CreatePePixelCrack()
{
	return std::make_shared<PePixelCrack>();
}

void SetPePixelCrack(std::shared_ptr<Entity> parent, float x, float y, int nMin, int nMax, UINT8 r, UINT8 g, UINT8 b)
{
	int num = Random(nMin, nMax);
	for (size_t i = 0; i < num; i++)
	{
		float angle_range = (float)Random(-30, 30);
		auto e = std::make_shared<PePixelCrack>();
		e->x = x;
		e->y = y;
		e->SetColor(r, g, b);
		parent->gameFunc->SetEntity(parent, e);
	}
}
