#include "MenuTextKeyboard.h"

void MenuTextKeyboard::Init(std::weak_ptr<Entity> self)
{
	auto wicon = std::make_shared<Entity>();
	icon = wicon;
	wicon->ani.png = L"menu_key";
	wicon->ani.hideLayerList.insert(1);
	wicon->x = x - 32;
	wicon->y = y;
	gameFunc->SetEntity(shared_from_this(), wicon);
	Entity::Init(self);
}

void MenuTextKeyboard::Step()
{
	switch (stateID)
	{
	default:
	case 0:
		if (gameFunc)
		{
			if (gameFunc->GetScanCodeName)
			{
				if (GetInputSetting())
				{
					gameFunc->GetScanCodeName(&name, *GetBind(GetInputSetting()));
					//ͼ
					auto wicon = icon.lock();
					if (wicon)
					{
						wicon->ani.sprite_index.clear();
						wicon->ani.sprite_index.append(L"keyboard_");
						wicon->ani.sprite_index.append(name.data());
					}
					//ı
					if (el.eid != name.data())
						el.eid = name.data();
				}
			}
		}
		break;
	case 1://״̬
		if (gameFunc)
		{
			if (gameFunc->GetAnyKeyPress && GetInputSetting())
			{
				SDL_Scancode key;
				auto p = GetInputSetting();
				if (gameFunc->GetAnyKeyPress(&key))
				{
					*GetBind(p) = key;
					stateID = 0;
					//ͼ
					auto wicon = icon.lock();
					if (wicon)
						wicon->ani.sprite_index = L"";
					//ı
					ani.png = ani.sprite_index = L"";
					el.flag.text = true;
					gameFunc->GetScanCodeName(&name, *GetBind(p));
					el.eid = name.data();
					gameFunc->SaveConfig();
					//ſ
					gameFunc->ResetKeyboard();
				}
			}
		}
		break;
	}
}

void MenuTextKeyboard::SetState(int stateID, int lr)
{
	this->stateID = stateID;
	if (stateID == 1)
	{
		ani.png = L"menu_CS_title";
		ani.sprite_index = L"msg_pressAnyKey";
		el.eid = L"";
		el.flag.text = false;
	}
}
